/// <reference path="./internal_*.d.ts" />
declare namespace net.blay09.mods.netherportalfix.mixin {
    interface LivingEntityAccessor {
        abstract getLastPos(): BlockPos;
        get lastPos(): BlockPos
        (): BlockPos_;
    }
    type LivingEntityAccessor_ = LivingEntityAccessor;
}
declare namespace Internal {
    class TagMatchTest extends Internal.RuleTest implements Internal.TagMatchTestAccessor {
        constructor($$0: Internal.TagKey_<Internal.Block>)
        getTag(): Internal.TagKey<any>;
        get tag(): Internal.TagKey<any>
        static readonly CODEC: Internal.Codec<Internal.TagMatchTest>;
    }
    type TagMatchTest_ = TagMatchTest;
    class ResourceKey <T> implements Internal.SpecialEquality {
        constructor($$0: ResourceLocation_, $$1: ResourceLocation_)
        static create<T>($$0: ResourceLocation_, $$1: ResourceLocation_): Internal.ResourceKey<T>;
        location(): ResourceLocation;
        static createRegistryKey<T>($$0: ResourceLocation_): Internal.ResourceKey<Internal.Registry<T>>;
        static checkSpecialEquality(o: any, o1: any, shallow: boolean): boolean;
        static create<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>, $$1: ResourceLocation_): Internal.ResourceKey<T>;
        registry(): ResourceLocation;
        specialEquals(o: any, shallow: boolean): boolean;
        isFor($$0: Internal.ResourceKey_<Internal.Registry<any>>): boolean;
        getPath(): string;
        static codec<T>($$0: Internal.ResourceKey_<Internal.Registry<T>>): Internal.Codec<Internal.ResourceKey<T>>;
        cast<E>($$0: Internal.ResourceKey_<Internal.Registry<E>>): Internal.Optional<Internal.ResourceKey<E>>;
        getNamespace(): string;
        get path(): string
        get namespace(): string
    }
    type ResourceKey_<T> = ResourceKey<T>;
    class PostboxBlock extends Internal.HorizontalDirectionalBlock implements Internal.ProperWaterloggedBlock, Internal.IBE<Internal.PostboxBlockEntity>, com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(properties: Internal.BlockBehaviour$Properties_, color: Internal.DyeColor_)
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.PostboxBlockEntity>;
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.PostboxBlockEntity;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        getBlockEntityType(): Internal.BlockEntityType<Internal.PostboxBlockEntity>;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.PostboxBlockEntity>): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getColor(): Internal.DyeColor;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.PostboxBlockEntity;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.PostboxBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        get blockEntityType(): Internal.BlockEntityType<Internal.PostboxBlockEntity>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        get blockEntityClass(): typeof Internal.PostboxBlockEntity
        static readonly OPEN: Internal.BooleanProperty;
    }
    type PostboxBlock_ = PostboxBlock;
    class NoConfigBuilder <R, T extends R, P> extends Internal.AbstractBuilder<R, T, P, Internal.NoConfigBuilder<R, T, P>> {
        constructor(owner: Internal.AbstractRegistrate_<any>, parent: P, name: string, callback: Internal.BuilderCallback_, registryType: Internal.ResourceKey_<Internal.Registry<R>>, factory: Internal.NonNullSupplier_<T>)
        lazy(): Internal.NonNullSupplier<Internal.RegistryEntry<T>>;
        addMiscData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: com.tterrag.registrate.util.nullness.NonNullConsumer_<D>): this;
        onRegisterAfter<OR>(dependencyType: Internal.ResourceKey_<Internal.Registry<OR>>, callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): this;
        transform<R2, T2 extends R2, P2, S2 extends Internal.Builder<R2, T2, P2, S2>>(func: com.tterrag.registrate.util.nullness.NonNullFunction_<Internal.NoConfigBuilder<R, T, P>, S2>): S2;
        static of<T>(sup: Internal.Supplier_<T>, errorMsg: Internal.NonNullSupplier_<string>): Internal.NonNullSupplier<T>;
        onRegister(callback: com.tterrag.registrate.util.nullness.NonNullConsumer_<T>): this;
        static of<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        setData<D extends Internal.RegistrateProvider>(type: Internal.ProviderType_<D>, cons: Internal.NonNullBiConsumer_<Internal.DataGenContext<R, T>, D>): this;
        getEntry(): T;
        static lazy<T>(sup: Internal.Supplier_<T>): Internal.NonNullSupplier<T>;
        get(): Internal.RegistryEntry<T>;
        build(): P;
        get entry(): T
    }
    type NoConfigBuilder_<R, T extends R, P> = NoConfigBuilder<R, T, P>;
    class SmartFluidTankBehaviour$TankSegment {
        constructor(this$0: Internal.SmartFluidTankBehaviour_, capacity: number)
        onFluidStackChanged(): void;
        writeNBT(): Internal.CompoundTag;
        isEmpty(partialTicks: number): boolean;
        getFluidLevel(): Internal.LerpedFloat;
        getTank(): Internal.SmartFluidTank;
        getTotalUnits(partialTicks: number): number;
        readNBT(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getRenderedFluid(): Internal.FluidStack;
        get fluidLevel(): Internal.LerpedFloat
        get tank(): Internal.SmartFluidTank
        get renderedFluid(): Internal.FluidStack
    }
    type SmartFluidTankBehaviour$TankSegment_ = SmartFluidTankBehaviour$TankSegment;
    interface LevelHeightAccessor {
        getSectionYFromSectionIndex($$0: number): number;
        isOutsideBuildHeight($$0: number): boolean;
        create($$0: number, $$1: number): this;
        getMinSection(): number;
        getSectionsCount(): number;
        abstract getMinBuildHeight(): number;
        getSectionIndex($$0: number): number;
        getMaxSection(): number;
        getSectionIndexFromSectionY($$0: number): number;
        abstract getHeight(): number;
        getMaxBuildHeight(): number;
        isOutsideBuildHeight($$0: BlockPos_): boolean;
        get minSection(): number
        get sectionsCount(): number
        get minBuildHeight(): number
        get maxSection(): number
        get height(): number
        get maxBuildHeight(): number
    }
    type LevelHeightAccessor_ = LevelHeightAccessor;
    abstract class AbstractComputerItem extends Internal.BlockItem implements Internal.IComputerItem {
        constructor(block: Internal.AbstractComputerBlock_<any>, settings: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        abstract changeItem(arg0: Internal.ItemStack_, arg1: Internal.Item_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getComputerID(stack: Internal.ItemStack_): number;
        getLabel(stack: Internal.ItemStack_): string;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AbstractComputerItem_ = AbstractComputerItem;
    class ViewCellItem extends Internal.AEBaseItem implements Internal.ICellWorkbenchItem {
        constructor(properties: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getConfigInventory(is: Internal.ItemStack_): Internal.ConfigInventory;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        static createItemFilter(list: Internal.Collection_<Internal.ItemStack>): Internal.IPartitionList;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        setFuzzyMode(is: Internal.ItemStack_, fzMode: Internal.FuzzyMode_): void;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getFuzzyMode(is: Internal.ItemStack_): Internal.FuzzyMode;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        static createFilter(filter: Internal.AEKeyFilter_, list: Internal.Collection_<Internal.ItemStack>): Internal.IPartitionList;
        getUpgrades(is: Internal.ItemStack_): Internal.IUpgradeInventory;
        emi(amount: number): Internal.EmiStack;
        isEditable(is: Internal.ItemStack_): boolean;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        emi(): Internal.EmiStack;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ViewCellItem_ = ViewCellItem;
    class EventExit extends Internal.Exception {
        constructor(result: Internal.EventResult_)
        readonly result: Internal.EventResult;
    }
    type EventExit_ = EventExit;
    interface Object2ObjectMap <K, V> extends Internal.Object2ObjectFunction<K, V>, Internal.Map<K, V> {
        computeIfAbsent(arg0: K, arg1: Internal.Function_<K, V>): V;
        abstract containsValue(arg0: any): boolean;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ObjectFunction<V>;
        keySet(): Internal.Set<any>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        computeIfAbsent(arg0: K, arg1: Internal.Object2ObjectFunction_<K, V>): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Object2FloatFunction<K>;
        abstract get(arg0: any): V;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        values(): Internal.Collection<any>;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ObjectFunction<V>;
        entrySet(): Internal.ObjectSet<Internal.Map$Entry<K, V>>;
        putIfAbsent(arg0: K, arg1: V): V;
        apply(arg0: K): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Object2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ObjectFunction<V>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Object2DoubleFunction<K>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ObjectFunction<V>;
        /**
         * @deprecated
        */
        computeObjectIfAbsentPartial(arg0: K, arg1: Internal.Object2ObjectFunction_<K, V>): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Object2CharFunction<K>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        replace(arg0: K, arg1: V, arg2: V): boolean;
        abstract defaultReturnValue(): V;
        identity<T>(): Internal.Function<T, T>;
        abstract defaultReturnValue(arg0: V): void;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        replace(arg0: K, arg1: V): V;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<K, V>;
        computeIfPresent(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        of<K, V>(): Internal.Map<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ObjectFunction<V>;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        abstract containsKey(arg0: any): boolean;
        put(arg0: K, arg1: V): V;
        abstract object2ObjectEntrySet(): Internal.ObjectSet<Internal.Object2ObjectMap$Entry<K, V>>;
        remove(arg0: any): V;
        merge(arg0: K, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        forEach(arg0: Internal.BiConsumer_<K, V>): void;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Object2LongFunction<K>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Object2IntFunction<K>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Object2ShortFunction<K>;
        compute(arg0: K, arg1: Internal.BiFunction_<K, V, V>): V;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ObjectFunction<V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ObjectFunction<T, V>;
        abstract putAll(arg0: Internal.Map_<K, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Object2ByteFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ObjectFunction<T, V>;
        abstract size(): number;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ObjectFunction<V>;
        abstract hashCode(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Object2ObjectFunction<K, T>;
        replaceAll(arg0: Internal.BiFunction_<K, V, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        abstract equals(arg0: any): boolean;
        get empty(): boolean
    }
    type Object2ObjectMap_<K, V> = Object2ObjectMap<K, V>;
    class ClientboundPlayerInfoUpdatePacket$Entry extends Internal.Record {
        constructor($$0: Internal.UUID_, $$1: Internal.GameProfile_, $$2: boolean, $$3: number, $$4: Internal.GameType_, $$5: net.minecraft.network.chat.Component_, $$6: Internal.RemoteChatSession$Data_)
        chatSession(): Internal.RemoteChatSession$Data;
        latency(): number;
        listed(): boolean;
        displayName(): net.minecraft.network.chat.Component;
        profile(): Internal.GameProfile;
        profileId(): Internal.UUID;
        gameMode(): Internal.GameType;
    }
    type ClientboundPlayerInfoUpdatePacket$Entry_ = ClientboundPlayerInfoUpdatePacket$Entry;
    class AutoCookingUpgradeConfig extends Internal.CookingUpgradeConfig {
        constructor(builder: Internal.ForgeConfigSpec$Builder_, upgradeName: string, path: string)
        readonly inputFilterSlotsInRow: Internal.ForgeConfigSpec$IntValue;
        readonly inputFilterSlots: Internal.ForgeConfigSpec$IntValue;
        readonly fuelFilterSlots: Internal.ForgeConfigSpec$IntValue;
        readonly fuelFilterSlotsInRow: Internal.ForgeConfigSpec$IntValue;
    }
    type AutoCookingUpgradeConfig_ = AutoCookingUpgradeConfig;
    class Goat extends Internal.Animal {
        constructor($$0: Internal.EntityType_<Internal.Goat>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getBreedOffspring($$0: Internal.ServerLevel_, $$1: Internal.AgeableMob_): this;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        isScreamingGoat(): boolean;
        static tickEntity(entity: Internal.Entity_): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        createHorn(): Internal.ItemStack;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getRammingXHeadRot(): number;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        getDistance(x: number, y: number, z: number): number;
        hasLeftHorn(): boolean;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        hasRightHorn(): boolean;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        setScreamingGoat($$0: boolean): void;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getBrain(): Internal.Brain<Internal.Goat>;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        removeHorns(): void;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        getServer(): Internal.MinecraftServer;
        addHorns(): void;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        dropHorn(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        static checkGoatSpawnRules($$0: Internal.EntityType_<Internal.Animal>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get screamingGoat(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get rammingXHeadRot(): number
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        set screamingGoat($$0: boolean)
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        set totalMovementSpeedMultiplier(speed: number)
        get brain(): Internal.Brain<Internal.Goat>
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        static readonly LONG_JUMPING_DIMENSIONS: Internal.EntityDimensions;
        static readonly UNIHORN_CHANCE: 0.10000000149011612;
        static readonly GOAT_FALL_DAMAGE_REDUCTION: 10;
        static readonly GOAT_SCREAMING_CHANCE: 0.02;
    }
    type Goat_ = Goat;
    class LavaSubmergedBlockProcessor extends Internal.StructureProcessor {
        constructor()
        static readonly CODEC: Internal.Codec<Internal.LavaSubmergedBlockProcessor>;
        static readonly INSTANCE: Internal.LavaSubmergedBlockProcessor;
    }
    type LavaSubmergedBlockProcessor_ = LavaSubmergedBlockProcessor;
    interface DoubleConsumer {
        abstract accept(arg0: number): void;
        andThen(arg0: Internal.DoubleConsumer_): this;
        (arg0: number): void;
    }
    type DoubleConsumer_ = DoubleConsumer;
    class BeltProcessingBehaviour$ProcessingResult extends Internal.Enum<Internal.BeltProcessingBehaviour$ProcessingResult> {
        static valueOf(name: string): Internal.BeltProcessingBehaviour$ProcessingResult;
        static values(): Internal.BeltProcessingBehaviour$ProcessingResult[];
        static readonly REMOVE: Internal.BeltProcessingBehaviour$ProcessingResult;
        static readonly PASS: Internal.BeltProcessingBehaviour$ProcessingResult;
        static readonly HOLD: Internal.BeltProcessingBehaviour$ProcessingResult;
    }
    type BeltProcessingBehaviour$ProcessingResult_ = "remove" | "pass" | "hold" | BeltProcessingBehaviour$ProcessingResult;
    class BindingCardItem extends owmii.powah.lib.item.ItemBase {
        constructor(properties: Internal.Item$Properties_, isMultiDim: boolean)
        getPlayer(level: Internal.ServerLevel_, stack: Internal.ItemStack_): Internal.Optional<Internal.ServerPlayer>;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isMultiDim(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        oneTimeInfo(player: Internal.Player_, stack: Internal.ItemStack_, component: net.minecraft.network.chat.Component_): void;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        getItemModelType(): Internal.ItemModelType;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get itemModelType(): Internal.ItemModelType
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type BindingCardItem_ = BindingCardItem;
    class FlywheelBlock extends Internal.RotatedPillarKineticBlock implements Internal.IBE<Internal.FlywheelBlockEntity> {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        newBlockEntity(p_153215_: BlockPos_, p_153216_: Internal.BlockState_): Internal.BlockEntity;
        getBlockEntityType(): Internal.BlockEntityType<Internal.FlywheelBlockEntity>;
        getBlockEntityClass(): typeof Internal.FlywheelBlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        hideStressImpact(): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.FlywheelBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.FlywheelBlockEntity>): void;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.FlywheelBlockEntity;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        showCapacityWithAnnotation(): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.FlywheelBlockEntity>;
        getMinimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel;
        emi(amount: number): Internal.EmiStack;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockEntityType(): Internal.BlockEntityType<Internal.FlywheelBlockEntity>
        get blockEntityClass(): typeof Internal.FlywheelBlockEntity
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get minimumRequiredSpeedLevel(): Internal.IRotate$SpeedLevel
    }
    type FlywheelBlock_ = FlywheelBlock;
    interface IotaPredicate {
        abstract test(arg0: Internal.Iota_): boolean;
        or(left: Internal.IotaPredicate_, right: Internal.IotaPredicate_): this;
        any(...any: Internal.IotaPredicate_[]): this;
        any(any: Internal.List_<Internal.IotaPredicate>): this;
        ofType(type: Internal.IotaType_<any>): this;
        (arg0: Internal.Iota): boolean;
        readonly TRUE: Internal.IotaPredicate;
    }
    type IotaPredicate_ = IotaPredicate;
    interface ITeleporter {
        isVanilla(): boolean;
        playTeleportSound(player: Internal.ServerPlayer_, sourceWorld: Internal.ServerLevel_, destWorld: Internal.ServerLevel_): boolean;
        getPortalInfo(entity: Internal.Entity_, destWorld: Internal.ServerLevel_, defaultPortalInfo: Internal.Function_<Internal.ServerLevel, Internal.PortalInfo>): Internal.PortalInfo;
        placeEntity(entity: Internal.Entity_, currentWorld: Internal.ServerLevel_, destWorld: Internal.ServerLevel_, yaw: number, repositionEntity: Internal.Function_<boolean, Internal.Entity>): Internal.Entity;
        get vanilla(): boolean
    }
    type ITeleporter_ = ITeleporter;
    class ColumnFeatureConfiguration implements Internal.FeatureConfiguration {
        constructor($$0: Internal.IntProvider_, $$1: Internal.IntProvider_)
        reach(): Internal.IntProvider;
        height(): Internal.IntProvider;
        getFeatures(): Internal.Stream<Internal.ConfiguredFeature<any, any>>;
        get features(): Internal.Stream<Internal.ConfiguredFeature<any, any>>
        static readonly CODEC: Internal.Codec<Internal.ColumnFeatureConfiguration>;
    }
    type ColumnFeatureConfiguration_ = ColumnFeatureConfiguration;
    abstract class BuilderBase <T> implements Internal.Supplier<T> {
        constructor(i: ResourceLocation_)
        createAdditionalObjects(): void;
        /**
         * Sets the display name for this object, e.g. `Stone`.
         * 
         * This will be overridden by a lang file if it exists.
        */
        displayName(name: net.minecraft.network.chat.Component_): this;
        getTranslationKeyGroup(): string;
        /**
         * Combined method of formattedDisplayName().displayName(name).
        */
        formattedDisplayName(name: net.minecraft.network.chat.Component_): this;
        transformObject(obj: T): T;
        abstract createObject(): T;
        getBuilderTranslationKey(): string;
        /**
         * Makes displayName() override language files.
        */
        formattedDisplayName(): this;
        generateDataJsons(generator: Internal.DataJsonGenerator_): void;
        abstract getRegistryType(): Internal.RegistryInfo<any>;
        /**
         * Sets the translation key for this object, e.g. `block.minecraft.stone`.
        */
        translationKey(key: string): this;
        get(): T;
        generateLang(lang: Internal.LangEventJS_): void;
        /**
         * Adds a tag to this object, e.g. `minecraft:stone`.
        */
        tag(tag: ResourceLocation_): this;
        newID(pre: string, post: string): ResourceLocation;
        generateAssetJsons(generator: Internal.AssetJsonGenerator_): void;
        get translationKeyGroup(): string
        get builderTranslationKey(): string
        get registryType(): Internal.RegistryInfo<any>
        displayName: net.minecraft.network.chat.Component;
        translationKey: string;
        formattedDisplayName: boolean;
        readonly id: ResourceLocation;
    }
    type BuilderBase_<T> = BuilderBase<T>;
    abstract class PosRuleTest {
        constructor()
        abstract test(arg0: BlockPos_, arg1: BlockPos_, arg2: BlockPos_, arg3: Internal.RandomSource_): boolean;
        static readonly CODEC: Internal.Codec<Internal.PosRuleTest>;
    }
    type PosRuleTest_ = PosRuleTest;
    class CragSplatterFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
    }
    type CragSplatterFeature_ = CragSplatterFeature;
    class AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper extends Internal.AutoCookingUpgradeWrapper<Internal.AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper, Internal.AutoBlastingUpgradeItem, Internal.BlastingRecipe> {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        hideSettingsTab(): boolean;
        onAdded(): void;
    }
    type AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper_ = AutoCookingUpgradeWrapper$AutoBlastingUpgradeWrapper;
    class ReplaceBlockFeature extends Internal.Feature<Internal.ReplaceBlockConfiguration> {
        constructor($$0: Internal.Codec_<Internal.ReplaceBlockConfiguration>)
    }
    type ReplaceBlockFeature_ = ReplaceBlockFeature;
    class Frog extends Internal.Animal implements Internal.VariantHolder<Internal.FrogVariant> {
        constructor($$0: Internal.EntityType_<Internal.Animal>, $$1: Internal.Level_)
        getDistance(pos: BlockPos_): number;
        splitIntoDynamicLightEntries(cellHasher: Internal.CellHasher_): Internal.Stream<Internal.SpatialLookupEntry>;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number): void;
        removeAttribute(attribute: Internal.Attribute_, identifier: string): void;
        playSound(id: Internal.SoundEvent_, volume: number, pitch: number): void;
        static port_lib$collideWithShapes(vec3: Vec3d_, aABB: Internal.AABB_, list: Internal.List_<Internal.VoxelShape>): Vec3d;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        setDefaultMovementSpeedMultiplier(speed: number): void;
        isTouchingUpsideDownFluid(): boolean;
        getOffHandItem(): Internal.ItemStack;
        isOnScoreboardTeam(teamId: string): boolean;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getEquipment(slot: Internal.EquipmentSlot_): Internal.ItemStack;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        swing(): void;
        setPosition(x: number, y: number, z: number): void;
        runCommandSilent(command: string): number;
        isPlayer(): boolean;
        isAnimal(): boolean;
        rayTrace(distance: number, fluids: boolean): Internal.RayTraceResultJS;
        asComponentProvider(): Internal.ComponentProvider;
        setY(y: number): void;
        isLiving(): boolean;
        damageEquipment(slot: Internal.EquipmentSlot_): void;
        static tickEntity(entity: Internal.Entity_): void;
        eraseTongueTarget(): void;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        rayTrace(): Internal.RayTraceResultJS;
        getTotalMovementSpeed(): number;
        alwaysAccepts(): boolean;
        getCustomData(): Internal.CompoundTag;
        damageHeldItem(): void;
        getDisplayName(): net.minecraft.network.chat.Component;
        setPosition(block: Internal.BlockContainerJS_): void;
        setMotionZ(z: number): void;
        mergeNbt(tag: Internal.CompoundTag_): Internal.Entity;
        attack(hp: number): void;
        lambdynlights$scheduleTrackedChunksRebuild(renderer: Internal.LevelRenderer_): void;
        getVariant(): any;
        getTeamId(): string;
        setMaxHealth(hp: number): void;
        getFacing(): Internal.Direction;
        canRiderInteract(): boolean;
        getLegsArmorItem(): Internal.ItemStack;
        setMainHandItem(item: Internal.ItemStack_): void;
        isHoldingInAnyHand(i: Internal.Ingredient_): boolean;
        captureDrops(value: Internal.Collection_<Internal.ItemEntity>): Internal.Collection<Internal.ItemEntity>;
        rayTrace(distance: number): Internal.RayTraceResultJS;
        getReachDistance(): number;
        getMotionX(): number;
        isWaterCreature(): boolean;
        static checkFrogSpawnRules($$0: Internal.EntityType_<Internal.Animal>, $$1: Internal.LevelAccessor_, $$2: Internal.MobSpawnType_, $$3: BlockPos_, $$4: Internal.RandomSource_): boolean;
        getItem(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        setX(x: number): void;
        setAttributeBaseValue(attribute: Internal.Attribute_, value: number): void;
        getDynamicLightChunksToRebuild(forced: boolean): Internal.LongSet;
        getPotionEffects(): Internal.EntityPotionEffectsJS;
        isFrame(): boolean;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        setLegsArmorItem(item: Internal.ItemStack_): void;
        playSound(id: Internal.SoundEvent_): void;
        foodEaten(is: Internal.ItemStack_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getDefaultMovementSpeed(): number;
        getHeldItem(hand: Internal.InteractionHand_): Internal.ItemStack;
        swing(hand: Internal.InteractionHand_): void;
        setVariant($$0: Internal.FrogVariant_): void;
        getDistance(x: number, y: number, z: number): number;
        setMotionY(y: number): void;
        static createAttributes(): Internal.AttributeSupplier$Builder;
        getAttributeTotalValue(attribute: Internal.Attribute_): number;
        isPeacefulCreature(): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        isUndead(): boolean;
        setRotation(yaw: number, pitch: number): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        isDynamicLightEnabled(): boolean;
        isAmbientCreature(): boolean;
        getVariant(): Internal.FrogVariant;
        isMonster(): boolean;
        getType(): string;
        self(): Internal.Entity;
        setChestArmorItem(item: Internal.ItemStack_): void;
        checkUpsideDownState(): void;
        getTouchingFluid(): Internal.FluidState;
        getBlock(): Internal.BlockContainerJS;
        getNbt(): Internal.CompoundTag;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setEquipment(slot: Internal.EquipmentSlot_, item: Internal.ItemStack_): void;
        getMotionY(): number;
        getName(): net.minecraft.network.chat.Component;
        getPassengers(): Internal.EntityArrayList;
        getBrain(): Internal.Brain<Internal.Frog>;
        setTotalMovementSpeedMultiplier(speed: number): void;
        sophisticatedInvalidateCaps(): void;
        lithiumOnEquipmentChanged(): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        setHeldItem(hand: Internal.InteractionHand_, item: Internal.ItemStack_): void;
        getTongueTarget(): Internal.Optional<Internal.Entity>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        damageHeldItem(hand: Internal.InteractionHand_, amount: number, onBroken: Internal.Consumer_<Internal.ItemStack>): void;
        getFeetArmorItem(): Internal.ItemStack;
        setDefaultMovementSpeed(speed: number): void;
        setOffHandItem(item: Internal.ItemStack_): void;
        getMainHandItem(): Internal.ItemStack;
        spawn(): void;
        setTongueTarget($$0: Internal.Entity_): void;
        getServer(): Internal.MinecraftServer;
        setMotionX(x: number): void;
        canEntityBeSeen(entity: Internal.LivingEntity_): boolean;
        teleportTo(dimension: ResourceLocation_, x: number, y: number, z: number, yaw: number, pitch: number): void;
        static gatherClosestChunks(chunks: Internal.LongSet_, x: number, y: number, z: number): void;
        captureDrops(): Internal.Collection<Internal.ItemEntity>;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        setNbt(nbt: Internal.CompoundTag_): void;
        getLevel(): Internal.Level;
        getScriptType(): Internal.ScriptType;
        setMovementSpeedAddition(speed: number): void;
        serializeNBT(): Internal.Tag;
        getHeadArmorItem(): Internal.ItemStack;
        modifyAttribute(attribute: Internal.Attribute_, identifier: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        setDynamicLightEnabled(enabled: boolean): void;
        setFeetArmorItem(item: Internal.ItemStack_): void;
        setPositionAndRotation(x: number, y: number, z: number, yaw: number, pitch: number): void;
        getChestArmorItem(): Internal.ItemStack;
        damageEquipment(slot: Internal.EquipmentSlot_, amount: number): void;
        getMotionZ(): number;
        lambdynlights$updateDynamicLight(renderer: Internal.LevelRenderer_): boolean;
        tell(message: net.minecraft.network.chat.Component_): void;
        setZ(z: number): void;
        setStatusMessage(message: net.minecraft.network.chat.Component_): void;
        getDistanceSq(pos: BlockPos_): number;
        changeDimension(p_20118_: Internal.ServerLevel_, teleporter: Internal.ITeleporter_): Internal.Entity;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getProfile(): Internal.GameProfile;
        setHeadArmorItem(item: Internal.ItemStack_): void;
        getAttributeBaseValue(attribute: Internal.Attribute_): number;
        static canEat($$0: Internal.LivingEntity_): boolean;
        setVariant(arg0: any): void;
        runCommand(command: string): number;
        set defaultMovementSpeedMultiplier(speed: number)
        get touchingUpsideDownFluid(): boolean
        get offHandItem(): Internal.ItemStack
        get player(): boolean
        get animal(): boolean
        set y(y: number)
        get living(): boolean
        get totalMovementSpeed(): number
        get customData(): Internal.CompoundTag
        get displayName(): net.minecraft.network.chat.Component
        set position(block: Internal.BlockContainerJS_)
        set motionZ(z: number)
        get variant(): any
        get teamId(): string
        set maxHealth(hp: number)
        get facing(): Internal.Direction
        get legsArmorItem(): Internal.ItemStack
        set mainHandItem(item: Internal.ItemStack_)
        get reachDistance(): number
        get motionX(): number
        get waterCreature(): boolean
        get item(): Internal.ItemStack
        set x(x: number)
        get potionEffects(): Internal.EntityPotionEffectsJS
        get frame(): boolean
        set legsArmorItem(item: Internal.ItemStack_)
        get defaultMovementSpeed(): number
        set variant($$0: Internal.FrogVariant_)
        set motionY(y: number)
        get peacefulCreature(): boolean
        get undead(): boolean
        get dynamicLightEnabled(): boolean
        get ambientCreature(): boolean
        get variant(): Internal.FrogVariant
        get monster(): boolean
        get type(): string
        set chestArmorItem(item: Internal.ItemStack_)
        get touchingFluid(): Internal.FluidState
        get block(): Internal.BlockContainerJS
        get nbt(): Internal.CompoundTag
        get motionY(): number
        get name(): net.minecraft.network.chat.Component
        get passengers(): Internal.EntityArrayList
        get brain(): Internal.Brain<Internal.Frog>
        set totalMovementSpeedMultiplier(speed: number)
        get tongueTarget(): Internal.Optional<Internal.Entity>
        get feetArmorItem(): Internal.ItemStack
        set defaultMovementSpeed(speed: number)
        set offHandItem(item: Internal.ItemStack_)
        get mainHandItem(): Internal.ItemStack
        set tongueTarget($$0: Internal.Entity_)
        get server(): Internal.MinecraftServer
        set motionX(x: number)
        set nbt(nbt: Internal.CompoundTag_)
        get level(): Internal.Level
        get scriptType(): Internal.ScriptType
        set movementSpeedAddition(speed: number)
        get headArmorItem(): Internal.ItemStack
        set dynamicLightEnabled(enabled: boolean)
        set feetArmorItem(item: Internal.ItemStack_)
        get chestArmorItem(): Internal.ItemStack
        get motionZ(): number
        set z(z: number)
        set statusMessage(message: net.minecraft.network.chat.Component_)
        get profile(): Internal.GameProfile
        set headArmorItem(item: Internal.ItemStack_)
        set variant(arg0: any)
        readonly tongueAnimationState: Internal.AnimationState;
        readonly croakAnimationState: Internal.AnimationState;
        static readonly TEMPTATION_ITEM: Internal.Ingredient;
        readonly jumpAnimationState: Internal.AnimationState;
        readonly swimIdleAnimationState: Internal.AnimationState;
        static readonly VARIANT_KEY: "variant";
    }
    type Frog_ = Frog;
    class MonolithFeature extends Internal.Feature<Internal.NoneFeatureConfiguration> {
        constructor(deserializer: Internal.Codec_<Internal.NoneFeatureConfiguration>)
        checkSpace(world: Internal.WorldGenLevel_, pos: BlockPos_, sizeX: number, sizeZ: number, height: number): boolean;
        setBlock(world: Internal.WorldGenLevel_, pos: BlockPos_, state: Internal.BlockState_): boolean;
    }
    type MonolithFeature_ = MonolithFeature;
    interface ClientPacketListenerAccessor {
        abstract port_lib$getServerChunkRadius(): number;
        (): number;
    }
    type ClientPacketListenerAccessor_ = ClientPacketListenerAccessor;
    class AnimatedScrollItem extends Internal.Item implements Internal.IotaHolderItem {
        constructor(size: number)
        canWrite(stack: Internal.ItemStack_, iota: Internal.Iota_): boolean;
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        writeable(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getColor(stack: Internal.ItemStack_): number;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        readIotaTag(stack: Internal.ItemStack_): Internal.CompoundTag;
        static appendHoverText(self: Internal.IotaHolderItem_, stack: Internal.ItemStack_, components: Internal.List_<net.minecraft.network.chat.Component>, flag: Internal.TooltipFlag_): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        writeDatum(stack: Internal.ItemStack_, iota: Internal.Iota_): void;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        readIota(stack: Internal.ItemStack_, world: Internal.ServerLevel_): Internal.Iota;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emptyIota(stack: Internal.ItemStack_): Internal.Iota;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AnimatedScrollItem_ = AnimatedScrollItem;
    interface InjectedGameEventExtension extends Internal.InjectedRegistryEntryExtension<Internal.GameEvent> {
        arch$registryName(): ResourceLocation;
        arch$holder(): Internal.Holder<Internal.GameEvent>;
    }
    type InjectedGameEventExtension_ = InjectedGameEventExtension;
    class ShulkerBoxBlock extends Internal.BaseEntityBlock {
        constructor($$0: Internal.DyeColor_, $$1: Internal.BlockBehaviour$Properties_)
        static getBlockByColor($$0: Internal.DyeColor_): Internal.Block;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        static getColorFromBlock($$0: Internal.Block_): Internal.DyeColor;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static getColorFromItem($$0: Internal.Item_): Internal.DyeColor;
        static getColoredItemStack($$0: Internal.DyeColor_): Internal.ItemStack;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
        static readonly CONTENTS: ResourceLocation;
        static readonly FACING: Internal.DirectionProperty;
    }
    type ShulkerBoxBlock_ = ShulkerBoxBlock;
    class MenuItem extends Internal.MenuComponent implements Internal.Accessible {
        constructor()
        constructor(arg0: string, arg1: Internal.MenuShortcut_)
        constructor(arg0: string)
        /**
         * @deprecated
        */
        disable(): void;
        setShortcut(arg0: Internal.MenuShortcut_): void;
        deleteShortcut(): void;
        paramString(): string;
        getLabel(): string;
        setEnabled(arg0: boolean): void;
        getListeners<T extends Internal.EventListener>(arg0: T): T[];
        /**
         * @deprecated
        */
        enable(): void;
        isEnabled(): boolean;
        addActionListener(arg0: Internal.ActionListener_): void;
        getShortcut(): Internal.MenuShortcut;
        setActionCommand(arg0: string): void;
        setLabel(arg0: string): void;
        getActionCommand(): string;
        /**
         * @deprecated
        */
        enable(arg0: boolean): void;
        removeActionListener(arg0: Internal.ActionListener_): void;
        addNotify(): void;
        getActionListeners(): Internal.ActionListener[];
        set shortcut(arg0: Internal.MenuShortcut_)
        get label(): string
        set enabled(arg0: boolean)
        get enabled(): boolean
        get shortcut(): Internal.MenuShortcut
        set actionCommand(arg0: string)
        set label(arg0: string)
        get actionCommand(): string
        get actionListeners(): Internal.ActionListener[]
    }
    type MenuItem_ = MenuItem;
    interface ClientTooltipPositioner {
        abstract positionTooltip(arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Vector2ic;
        (arg0: number, arg1: number, arg2: number, arg3: number, arg4: number, arg5: number): Internal.Vector2ic_;
    }
    type ClientTooltipPositioner_ = ClientTooltipPositioner;
    abstract class ClassLoader {
        getUnnamedModule(): Internal.Module;
        static getSystemResource(arg0: string): Internal.URL;
        getParent(): this;
        getResources(arg0: string): Internal.Enumeration<Internal.URL>;
        static getSystemResources(arg0: string): Internal.Enumeration<Internal.URL>;
        resources(arg0: string): Internal.Stream<Internal.URL>;
        getDefinedPackages(): Internal.Package[];
        setDefaultAssertionStatus(arg0: boolean): void;
        setPackageAssertionStatus(arg0: string, arg1: boolean): void;
        clearAssertionStatus(): void;
        setClassAssertionStatus(arg0: string, arg1: boolean): void;
        static getSystemResourceAsStream(arg0: string): Internal.InputStream;
        getName(): string;
        getDefinedPackage(arg0: string): Internal.Package;
        getResource(arg0: string): Internal.URL;
        loadClass(arg0: string): typeof any;
        getResourceAsStream(arg0: string): Internal.InputStream;
        static getPlatformClassLoader(): Internal.ClassLoader;
        static getSystemClassLoader(): Internal.ClassLoader;
        isRegisteredAsParallelCapable(): boolean;
        get unnamedModule(): Internal.Module
        get parent(): Internal.ClassLoader
        get definedPackages(): Internal.Package[]
        set defaultAssertionStatus(arg0: boolean)
        get name(): string
        get platformClassLoader(): Internal.ClassLoader
        get systemClassLoader(): Internal.ClassLoader
        get registeredAsParallelCapable(): boolean
    }
    type ClassLoader_ = ClassLoader;
    class DataTicket <D> {
        constructor(id: string, objectType: D)
        id(): string;
        getData<D>(dataMap: Internal.Map_<Internal.DataTicket<any>, any>): D;
        objectType(): D;
    }
    type DataTicket_<D> = DataTicket<D>;
    class MangroveLeavesBlock extends Internal.LeavesBlock implements Internal.BonemealableBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        isShearable(item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_): boolean;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        isBonemealSuccess($$0: Internal.Level_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        performBonemeal($$0: Internal.ServerLevel_, $$1: Internal.RandomSource_, $$2: BlockPos_, $$3: Internal.BlockState_): void;
        setRequiresTool(v: boolean): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        isValidBonemealTarget($$0: Internal.LevelReader_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: boolean): boolean;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        onSheared(player: Internal.Player_, item: Internal.ItemStack_, world: Internal.Level_, pos: BlockPos_, fortune: number): Internal.List<Internal.ItemStack>;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type MangroveLeavesBlock_ = MangroveLeavesBlock;
    abstract class SplitShaftBlockEntity extends Internal.DirectionalShaftHalvesBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        abstract getRotationSpeedModifier(arg0: Internal.Direction_): number;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get infiniteBoundingBox(): Internal.AABB
        get renderBoundingBox(): Internal.AABB
    }
    type SplitShaftBlockEntity_ = SplitShaftBlockEntity;
    interface PointOfInterestStorageExtended {
        abstract findNearestForPortalLogic(arg0: BlockPos_, arg1: number, arg2: Internal.Holder_<Internal.PoiType>, arg3: Internal.PoiManager$Occupancy_, arg4: Internal.Predicate_<Internal.PoiRecord>, arg5: Internal.WorldBorder_): Internal.Optional<Internal.PoiRecord>;
        (arg0: BlockPos, arg1: number, arg2: Internal.Holder<Internal.PoiType>, arg3: Internal.PoiManager$Occupancy, arg4: Internal.Predicate<Internal.PoiRecord>, arg5: Internal.WorldBorder): Internal.Optional_<Internal.PoiRecord>;
    }
    type PointOfInterestStorageExtended_ = PointOfInterestStorageExtended;
    class ThermoBlock extends Internal.AbstractGeneratorBlock<Internal.ThermoBlock> {
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockItem(arg0: Internal.Item$Properties_, arg1: Internal.ResourceKey_<any>): Internal.ItemBlock<any, any>;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getConfig(): Internal.GeneratorConfig;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get config(): Internal.GeneratorConfig
    }
    type ThermoBlock_ = ThermoBlock;
    interface IngredientPlatformHelper {
        abstract creativeTab(arg0: Internal.CreativeModeTab_): Internal.Ingredient;
        get(): this;
        abstract weakNBT(arg0: Internal.ItemStack_): Internal.Ingredient;
        abstract custom(arg0: Internal.Ingredient_, arg1: Internal.UUID_): Internal.Ingredient;
        abstract isWildcard(arg0: Internal.Ingredient_): boolean;
        abstract or(arg0: Internal.Ingredient_[]): Internal.Ingredient;
        abstract subtract(arg0: Internal.Ingredient_, arg1: Internal.Ingredient_): Internal.Ingredient;
        abstract mod(arg0: string): Internal.Ingredient;
        stack(ingredient: Internal.Ingredient_, count: number): InputItem;
        abstract custom(arg0: Internal.Ingredient_, arg1: Internal.Predicate_<Internal.ItemStack>): Internal.Ingredient;
        abstract wildcard(): Internal.Ingredient;
        abstract regex(arg0: Internal.Pattern_): Internal.Ingredient;
        abstract and(arg0: Internal.Ingredient_[]): Internal.Ingredient;
        abstract strongNBT(arg0: Internal.ItemStack_): Internal.Ingredient;
        tag(tag: string): Internal.Ingredient;
        readonly INSTANCE: Internal.Lazy<Internal.IngredientPlatformHelper>;
    }
    type IngredientPlatformHelper_ = IngredientPlatformHelper;
    /**
     * @deprecated
     * This class is marked to be removed in future!
    */
    interface BlockExtensions {
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
    }
    type BlockExtensions_ = BlockExtensions;
    interface Object2ObjectFunction <K, V> extends it.unimi.dsi.fastutil.Function<K, V> {
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<K, V>;
        getOrDefault(arg0: any, arg1: V): V;
        composeShort(arg0: Internal.Short2ObjectFunction_<K>): Internal.Short2ObjectFunction<V>;
        composeByte(arg0: Internal.Byte2ObjectFunction_<K>): Internal.Byte2ObjectFunction<V>;
        containsKey(arg0: any): boolean;
        put(arg0: K, arg1: V): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Object2FloatFunction<K>;
        abstract get(arg0: any): V;
        remove(arg0: any): V;
        composeFloat(arg0: Internal.Float2ObjectFunction_<K>): Internal.Float2ObjectFunction<V>;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Object2LongFunction<K>;
        apply(arg0: K): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Object2ReferenceFunction<K, T>;
        composeChar(arg0: Internal.Char2ObjectFunction_<K>): Internal.Char2ObjectFunction<V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Object2IntFunction<K>;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Object2ShortFunction<K>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Object2DoubleFunction<K>;
        composeInt(arg0: Internal.Int2ObjectFunction_<K>): Internal.Int2ObjectFunction<V>;
        composeObject<T>(arg0: Internal.Object2ObjectFunction_<T, K>): Internal.Object2ObjectFunction<T, V>;
        composeDouble(arg0: Internal.Double2ObjectFunction_<K>): Internal.Double2ObjectFunction<V>;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Object2ByteFunction<K>;
        composeReference<T>(arg0: Internal.Reference2ObjectFunction_<T, K>): Internal.Reference2ObjectFunction<T, V>;
        composeLong(arg0: Internal.Long2ObjectFunction_<K>): Internal.Long2ObjectFunction<V>;
        size(): number;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Object2CharFunction<K>;
        compose<V>(arg0: Internal.Function_<V, K>): Internal.Function<V, V>;
        clear(): void;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Object2ObjectFunction<K, T>;
        defaultReturnValue(): V;
        identity<T>(): Internal.Function<T, T>;
        defaultReturnValue(arg0: V): void;
        (arg0: any): V;
    }
    type Object2ObjectFunction_<K, V> = Object2ObjectFunction<K, V>;
    interface MappedRegistryAccessor {
        abstract setFrozen(arg0: boolean): void;
        set frozen(arg0: boolean)
        (arg0: boolean): void;
    }
    type MappedRegistryAccessor_ = MappedRegistryAccessor;
    class PhantomTrackBlock extends Internal.NoCollisionCustomTrackBlock implements Internal.TransparentSegmentTrackBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, material: Internal.TrackMaterial_)
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_, defaultMaterial: Internal.TrackMaterial_): Internal.TrackMaterial;
        getNearestTrackAxis(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, lookVec: Vec3d_): net.createmod.catnip.data.Pair<Vec3d, Internal.Direction$AxisDirection>;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        isSlope(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        handleBox(x1: number, y1: number, z1: number, x2: number, y2: number, z2: number, chance: number, state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): void;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        setLightEmission(v: number): void;
        getElevationAtCenter(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): number;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        getConnected(worldIn: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, linear: boolean, connectedTo: Internal.TrackNodeLocation_): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.TrackBlockEntity>): void;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.TrackBlockEntity>;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.TrackBlockEntity;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        static getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_): Internal.TrackMaterial;
        static walkConnectedTracks(worldIn: Internal.BlockGetter_, location: Internal.TrackNodeLocation_, linear: boolean): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getYOffsetAt(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, end: Vec3d_): number;
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getBlockStates(): Internal.List<Internal.BlockState>;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        overlay(world: Internal.BlockGetter_, pos: BlockPos_, existing: Internal.BlockState_, placed: Internal.BlockState_): Internal.BlockState;
        emi(amount: number): Internal.EmiStack;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.TrackBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        addDestroyEffects(state: Internal.BlockState_, world: Internal.ClientLevel_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        static addToListIfConnected(fromEnd: Internal.TrackNodeLocation_, list: Internal.Collection_<Internal.TrackNodeLocation$DiscoveredLocation>, offsetFactory: Internal.BiFunction_<number, boolean, Vec3d>, normalFactory: Internal.Function_<boolean, Vec3d>, dimensionFactory: Internal.Function_<boolean, Internal.ResourceKey<Internal.Level>>, yOffsetFactory: Internal.Function_<Vec3d, number>, axis: Vec3d_, viaTurn: Internal.BezierConnection_, materialFactory: Internal.BiFunction_<boolean, Vec3d, Internal.TrackMaterial>): void;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        set lightEmission(v: number)
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        get mod(): string
    }
    type PhantomTrackBlock_ = PhantomTrackBlock;
    interface DOMConfiguration {
        abstract canSetParameter(arg0: string, arg1: any): boolean;
        abstract getParameterNames(): Internal.DOMStringList;
        abstract getParameter(arg0: string): any;
        abstract setParameter(arg0: string, arg1: any): void;
        get parameterNames(): Internal.DOMStringList
    }
    type DOMConfiguration_ = DOMConfiguration;
    class MetricSampler {
        triggersThreshold(): boolean;
        static create<T>($$0: string, $$1: Internal.MetricCategory_, $$2: T, $$3: Internal.ToDoubleFunction_<T>): Internal.MetricSampler;
        static builder<T>($$0: string, $$1: Internal.MetricCategory_, $$2: Internal.ToDoubleFunction_<T>, $$3: T): Internal.MetricSampler$MetricSamplerBuilder<T>;
        result(): Internal.MetricSampler$SamplerResult;
        static create($$0: string, $$1: Internal.MetricCategory_, $$2: Internal.DoubleSupplier_): Internal.MetricSampler;
        getName(): string;
        getCategory(): Internal.MetricCategory;
        onFinished(): void;
        onEndTick($$0: number): void;
        onStartTick(): void;
        get name(): string
        get category(): Internal.MetricCategory
    }
    type MetricSampler_ = MetricSampler;
    class SeatBlock extends Internal.Block implements Internal.ProperWaterloggedBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, color: Internal.DyeColor_)
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        static sitDown(world: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): void;
        getBlockStates(): Internal.List<Internal.BlockState>;
        static canReplaceSeatedEntity(seated: Internal.Entity_, player: Internal.Player_): boolean;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getColor(): Internal.DyeColor;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static canBePickedUp(passenger: Internal.Entity_): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        static getLeashed(level: Internal.Level_, player: Internal.Player_): com.google.common.base.Optional<Internal.Entity>;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        static isSeatOccupied(world: Internal.Level_, pos: BlockPos_): boolean;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        get color(): Internal.DyeColor
        set destroySpeed(v: number)
    }
    type SeatBlock_ = SeatBlock;
    interface Aquifer$FluidPicker {
        abstract computeFluid(arg0: number, arg1: number, arg2: number): Internal.Aquifer$FluidStatus;
        (arg0: number, arg1: number, arg2: number): Internal.Aquifer$FluidStatus_;
    }
    type Aquifer$FluidPicker_ = Aquifer$FluidPicker;
    class EnderGateBlock extends Internal.AbstractEnergyBlock<Internal.EnderConfig, Internal.EnderGateBlock> {
        constructor(properties: Internal.BlockBehaviour$Properties_, variant: owmii.powah.block.Tier_)
        getConfig(): any;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>(level: Internal.Level_, state: Internal.BlockState_, blockEntityType: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockItem(arg0: Internal.Item$Properties_, arg1: Internal.ResourceKey_<any>): Internal.ItemBlock<any, any>;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        get config(): any
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type EnderGateBlock_ = EnderGateBlock;
    class TinyTNTBlock extends Internal.AEBaseBlock {
        constructor(props: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        startFuse(level: Internal.Level_, pos: BlockPos_, igniter: Internal.LivingEntity_): void;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getOrientation(state: Internal.BlockState_): Internal.BlockOrientation;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type TinyTNTBlock_ = TinyTNTBlock;
    class IceBlock extends Internal.HalfTransparentBlock {
        constructor($$0: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        static meltsInto(): Internal.BlockState;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
    }
    type IceBlock_ = IceBlock;
    class CommandContext <S> {
        constructor(arg0: S, arg1: string, arg2: Internal.Map_<string, Internal.ParsedArgument<S, any>>, arg3: Internal.Command_<S>, arg4: Internal.CommandNode_<S>, arg5: Internal.List_<Internal.ParsedCommandNode<S>>, arg6: Internal.StringRange_, arg7: Internal.CommandContext_<S>, arg8: Internal.RedirectModifier_<S>, arg9: boolean)
        getNodes(): Internal.List<Internal.ParsedCommandNode<S>>;
        getLastChild(): this;
        getInput(): string;
        getChild(): this;
        isForked(): boolean;
        getRedirectModifier(): Internal.RedirectModifier<S>;
        getSource(): S;
        getArgument<V>(arg0: string, arg1: V): V;
        getRootNode(): Internal.CommandNode<S>;
        copyFor(arg0: S): this;
        getCommand(): Internal.Command<S>;
        hasNodes(): boolean;
        getRange(): Internal.StringRange;
        get nodes(): Internal.List<Internal.ParsedCommandNode<S>>
        get lastChild(): Internal.CommandContext<S>
        get input(): string
        get child(): Internal.CommandContext<S>
        get forked(): boolean
        get redirectModifier(): Internal.RedirectModifier<S>
        get source(): S
        get rootNode(): Internal.CommandNode<S>
        get command(): Internal.Command<S>
        get range(): Internal.StringRange
    }
    type CommandContext_<S> = CommandContext<S>;
    class ClickType extends Internal.Enum<Internal.ClickType> {
        static values(): Internal.ClickType[];
        static valueOf($$0: string): Internal.ClickType;
        static readonly QUICK_CRAFT: Internal.ClickType;
        static readonly PICKUP_ALL: Internal.ClickType;
        static readonly QUICK_MOVE: Internal.ClickType;
        static readonly CLONE: Internal.ClickType;
        static readonly THROW: Internal.ClickType;
        static readonly PICKUP: Internal.ClickType;
        static readonly SWAP: Internal.ClickType;
    }
    type ClickType_ = "pickup" | "quick_move" | ClickType | "quick_craft" | "pickup_all" | "throw" | "swap" | "clone";
    class ShapelessRecipeSpec extends Internal.Record {
        constructor(properties: Internal.RecipeProperties_, ingredients: Internal.NonNullList_<Internal.Ingredient>, result: Internal.ItemStack_)
        properties(): Internal.RecipeProperties;
        static fromJson(json: Internal.JsonObject_): Internal.ShapelessRecipeSpec;
        ingredients(): Internal.NonNullList<Internal.Ingredient>;
        static fromNetwork(buffer: Internal.FriendlyByteBuf_): Internal.ShapelessRecipeSpec;
        toNetwork(buffer: Internal.FriendlyByteBuf_): void;
        result(): Internal.ItemStack;
    }
    type ShapelessRecipeSpec_ = ShapelessRecipeSpec;
    class BlockEntitySlipway$Companion {
        constructor($constructor_marker: any_)
        getRandomPigment(): Internal.FrozenPigment;
        static access$makeColours($this: Internal.BlockEntitySlipway$Companion_): number[];
        get randomPigment(): Internal.FrozenPigment
    }
    type BlockEntitySlipway$Companion_ = BlockEntitySlipway$Companion;
    class RandomizedIntStateProvider extends Internal.BlockStateProvider {
        constructor($$0: Internal.BlockStateProvider_, $$1: string, $$2: Internal.IntProvider_)
        constructor($$0: Internal.BlockStateProvider_, $$1: Internal.IntegerProperty_, $$2: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.RandomizedIntStateProvider>;
    }
    type RandomizedIntStateProvider_ = RandomizedIntStateProvider;
    class YggdrasilAuthenticationService extends Internal.HttpAuthenticationService {
        constructor(arg0: Internal.Proxy_, arg1: string, arg2: any_)
        constructor(arg0: Internal.Proxy_, arg1: string)
        constructor(arg0: Internal.Proxy_)
        constructor(arg0: Internal.Proxy_, arg1: any_)
        createUserApiService(arg0: string): Internal.UserApiService;
        getServicesKeySet(): Internal.ServicesKeySet;
        get servicesKeySet(): Internal.ServicesKeySet
    }
    type YggdrasilAuthenticationService_ = YggdrasilAuthenticationService;
    class InterfaceBlockEntity extends Internal.AENetworkBlockEntity implements Internal.IUpgradeableObject, Internal.IConfigurableObject, Internal.InterfaceLogicHost, Internal.IPriorityHost {
        constructor(blockEntityType: Internal.BlockEntityType_<any>, pos: BlockPos_, blockState: Internal.BlockState_)
        getDisplayName(): net.minecraft.network.chat.Component;
        static tryClear($$0: any): void;
        ifGridPresent(action: Internal.Consumer_<Internal.IGrid>): boolean;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        abstract getConfigManager(): Internal.IConfigManager;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getGridNode(): Internal.IGridNode;
        getGridNode(dir: Internal.Direction_): Internal.IGridNode;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        getInterfaceLogic(): Internal.InterfaceLogic;
        getMainMenuIcon(): Internal.ItemStack;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getConfig(): Internal.GenericStackInv;
        asComponentProvider(): Internal.ComponentProvider;
        getStorage(): Internal.GenericStackInv;
        hasCustomName(): boolean;
        returnToMainMenu(player: Internal.Player_, subMenu: Internal.ISubMenu_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        isUpgradedWith(upgradeCard: Internal.ItemLike_): boolean;
        getInstalledUpgrades(upgradeCard: Internal.ItemLike_): number;
        openMenu(player: Internal.Player_, locator: Internal.MenuLocator_): void;
        abstract setPriority(arg0: number): void;
        getActionableNode(): Internal.IGridNode;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        abstract getPriority(): number;
        getGridConnectableSides(orientation: Internal.BlockOrientation_): Internal.Set<Internal.Direction>;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getUpgrades(): Internal.IUpgradeInventory;
        setOwner(owner: Internal.Player_): void;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        get displayName(): net.minecraft.network.chat.Component
        get configManager(): Internal.IConfigManager
        get gridNode(): Internal.IGridNode
        get interfaceLogic(): Internal.InterfaceLogic
        get mainMenuIcon(): Internal.ItemStack
        get config(): Internal.GenericStackInv
        get storage(): Internal.GenericStackInv
        set priority(arg0: number)
        get actionableNode(): Internal.IGridNode
        get priority(): number
        get upgrades(): Internal.IUpgradeInventory
        set owner(owner: Internal.Player_)
    }
    type InterfaceBlockEntity_ = InterfaceBlockEntity;
    class CappedProcessor extends Internal.StructureProcessor {
        constructor($$0: Internal.StructureProcessor_, $$1: Internal.IntProvider_)
        static readonly CODEC: Internal.Codec<Internal.CappedProcessor>;
    }
    type CappedProcessor_ = CappedProcessor;
    interface TransparentSegmentTrackBlock extends Internal.ITrackBlock {
        abstract getCurveStart(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Vec3d_): Vec3d;
        getYOffsetAt(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, end: Vec3d_): number;
        getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_, defaultMaterial: Internal.TrackMaterial_): Internal.TrackMaterial;
        abstract prepareTrackOverlay<Self extends Internal.Affine<Self>>(arg0: Internal.Affine_<Self>, arg1: Internal.BlockGetter_, arg2: BlockPos_, arg3: Internal.BlockState_, arg4: Internal.BezierTrackPointLocation_, arg5: Internal.Direction$AxisDirection_, arg6: Internal.TrackTargetingBehaviour$RenderedTrackOverlayType_): Internal.PartialModel;
        getNearestTrackAxis(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, lookVec: Vec3d_): net.createmod.catnip.data.Pair<Vec3d, Internal.Direction$AxisDirection>;
        abstract getTrackAxes(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.List<Vec3d>;
        abstract getBogeyAnchor(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Internal.BlockState;
        isSlope(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): boolean;
        abstract prepareAssemblyOverlay(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_, arg3: Internal.Direction_, arg4: Internal.PoseStack_): Internal.PartialModel;
        getConnected(worldIn: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, linear: boolean, connectedTo: Internal.TrackNodeLocation_): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        overlay(world: Internal.BlockGetter_, pos: BlockPos_, existing: Internal.BlockState_, placed: Internal.BlockState_): Internal.BlockState;
        getMaterialSimple(world: Internal.BlockGetter_, pos: Vec3d_): Internal.TrackMaterial;
        walkConnectedTracks(worldIn: Internal.BlockGetter_, location: Internal.TrackNodeLocation_, linear: boolean): Internal.Collection<Internal.TrackNodeLocation$DiscoveredLocation>;
        abstract getMaterial(): Internal.TrackMaterial;
        abstract getUpNormal(arg0: Internal.BlockGetter_, arg1: BlockPos_, arg2: Internal.BlockState_): Vec3d;
        addToListIfConnected(fromEnd: Internal.TrackNodeLocation_, list: Internal.Collection_<Internal.TrackNodeLocation$DiscoveredLocation>, offsetFactory: Internal.BiFunction_<number, boolean, Vec3d>, normalFactory: Internal.Function_<boolean, Vec3d>, dimensionFactory: Internal.Function_<boolean, Internal.ResourceKey<Internal.Level>>, yOffsetFactory: Internal.Function_<Vec3d, number>, axis: Vec3d_, viaTurn: Internal.BezierConnection_, materialFactory: Internal.BiFunction_<boolean, Vec3d, Internal.TrackMaterial>): void;
        getElevationAtCenter(world: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_): number;
        abstract trackEquals(arg0: Internal.BlockState_, arg1: Internal.BlockState_): boolean;
        get material(): Internal.TrackMaterial
    }
    type TransparentSegmentTrackBlock_ = TransparentSegmentTrackBlock;
    class ScoreHolderArgument$Info$Template implements Internal.ArgumentTypeInfo$Template<Internal.ScoreHolderArgument> {
        instantiate(arg0: Internal.CommandBuildContext_): Internal.ArgumentType<any>;
        type(): Internal.ArgumentTypeInfo<Internal.ScoreHolderArgument, any>;
        instantiate($$0: Internal.CommandBuildContext_): Internal.ScoreHolderArgument;
    }
    type ScoreHolderArgument$Info$Template_ = ScoreHolderArgument$Info$Template;
    class ClientLinkableHolder {
        constructor(thisLinkable: Internal.ILinkable$IRenderCentre_, level: Internal.Level_, random: Internal.RandomSource_)
        addRenderLink(otherTag: Internal.CompoundTag_, other: Internal.ILinkable$IRenderCentre_): void;
        setRenderLinks(newLinks: Internal.Map_<Internal.CompoundTag, Internal.ILinkable$IRenderCentre>): void;
        removeRenderLink(otherTag: Internal.CompoundTag_): Internal.ILinkable$IRenderCentre;
        renderLinks(): void;
        set renderLinks(newLinks: Internal.Map_<Internal.CompoundTag, Internal.ILinkable$IRenderCentre>)
    }
    type ClientLinkableHolder_ = ClientLinkableHolder;
    abstract class TextureAtlasHolder implements Internal.TextureAtlasHolderInvoker, Internal.PreparableReloadListener, Internal.AutoCloseable {
        constructor($$0: Internal.TextureManager_, $$1: ResourceLocation_, $$2: ResourceLocation_)
        close(): void;
        getName(): string;
        emiffect$invokeGetSprite(arg0: ResourceLocation_): Internal.TextureAtlasSprite;
        reload($$0: Internal.PreparableReloadListener$PreparationBarrier_, $$1: Internal.ResourceManager_, $$2: Internal.ProfilerFiller_, $$3: Internal.ProfilerFiller_, $$4: Internal.Executor_, $$5: Internal.Executor_): Internal.CompletableFuture<void>;
        get name(): string
    }
    type TextureAtlasHolder_ = TextureAtlasHolder;
    class Lifecycle {
        static experimental(): Internal.Lifecycle;
        static deprecated(arg0: number): Internal.Lifecycle;
        add(arg0: Internal.Lifecycle_): this;
        static stable(): Internal.Lifecycle;
    }
    type Lifecycle_ = Lifecycle;
    class ItemTideTrident extends Internal.TridentItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        kjs$getMutableAttributeMap(): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemTideTrident_ = ItemTideTrident;
    class EnergyCellBlockItem extends Internal.AEBaseBlockItem implements Internal.IAEItemPowerStorage {
        constructor(block: Internal.Block_, props: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        getPowerFlow(is: Internal.ItemStack_): Internal.AccessRestriction;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        getChargeRate(stack: Internal.ItemStack_): number;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        getAEMaxPower(is: Internal.ItemStack_): number;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        extractAEPower(is: Internal.ItemStack_, amount: number, mode: Internal.Actionable_): number;
        injectAEPower(is: Internal.ItemStack_, amount: number, mode: Internal.Actionable_): number;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        getAECurrentPower(is: Internal.ItemStack_): number;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnergyCellBlockItem_ = EnergyCellBlockItem;
    interface MEStorage {
        getAvailableStacks(out: Internal.KeyCounter_): void;
        checkPreconditions(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): void;
        isPreferredStorageFor(what: Internal.AEKey_, source: Internal.IActionSource_): boolean;
        getAvailableStacks(): Internal.KeyCounter;
        extract(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): number;
        insert(what: Internal.AEKey_, amount: number, mode: Internal.Actionable_, source: Internal.IActionSource_): number;
        abstract getDescription(): net.minecraft.network.chat.Component;
        get availableStacks(): Internal.KeyCounter
        get description(): net.minecraft.network.chat.Component
        (): net.minecraft.network.chat.Component_;
        readonly SIDED: Internal.BlockApiLookup<Internal.MEStorage, Internal.Direction>;
    }
    type MEStorage_ = MEStorage;
    interface HasCustomInventoryScreen {
        abstract openCustomInventoryScreen(arg0: Internal.Player_): void;
        (arg0: Internal.Player): void;
    }
    type HasCustomInventoryScreen_ = HasCustomInventoryScreen;
    interface Int2ObjectMap <V> extends Internal.Int2ObjectFunction<V>, Internal.Map<number, V> {
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        composeLong(arg0: Internal.Long2IntFunction_): Internal.Long2ObjectFunction<V>;
        put(arg0: number, arg1: V): V;
        abstract containsValue(arg0: any): boolean;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        abstract containsKey(arg0: number): boolean;
        keySet(): Internal.Set<any>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V): Internal.Map<K, V>;
        putIfAbsent(arg0: number, arg1: V): V;
        andThenByte(arg0: Internal.Object2ByteFunction_<V>): Internal.Int2ByteFunction;
        replace(arg0: number, arg1: V): V;
        /**
         * @deprecated
        */
        get(arg0: any): V;
        apply(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: any, arg1: any): any;
        apply(arg0: number): V;
        copyOf<K, V>(arg0: Internal.Map_<K, V>): Internal.Map<K, V>;
        compute(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        /**
         * @deprecated
        */
        entrySet(): Internal.Set<any>;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        composeByte(arg0: Internal.Byte2IntFunction_): Internal.Byte2ObjectFunction<V>;
        andThenDouble(arg0: Internal.Object2DoubleFunction_<V>): Internal.Int2DoubleFunction;
        computeIfPresent(arg0: number, arg1: Internal.BiFunction_<number, V, V>): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V): Internal.Map<K, V>;
        andThenInt(arg0: Internal.Object2IntFunction_<V>): Internal.Int2IntFunction;
        composeObject<T>(arg0: Internal.Object2IntFunction_<T>): Internal.Object2ObjectFunction<T, V>;
        remove(arg0: number): V;
        getOrDefault(arg0: number, arg1: V): V;
        andThenFloat(arg0: Internal.Object2FloatFunction_<V>): Internal.Int2FloatFunction;
        andThenObject<T>(arg0: Internal.Object2ObjectFunction_<V, T>): Internal.Int2ObjectFunction<T>;
        composeDouble(arg0: Internal.Double2IntFunction_): Internal.Double2ObjectFunction<V>;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V): Internal.Map<K, V>;
        ofEntries<K, V>(...arg0: Internal.Map$Entry_<K, V>[]): Internal.Map<K, V>;
        computeIfAbsent(arg0: number, arg1: Internal.Function_<number, V>): V;
        composeChar(arg0: Internal.Char2IntFunction_): Internal.Char2ObjectFunction<V>;
        abstract defaultReturnValue(): V;
        identity<T>(): Internal.Function<T, T>;
        abstract defaultReturnValue(arg0: V): void;
        composeFloat(arg0: Internal.Float2IntFunction_): Internal.Float2ObjectFunction<V>;
        of<K, V>(arg0: K, arg1: V): Internal.Map<K, V>;
        andThen<V>(arg0: Internal.Function_<V, V>): Internal.Function<number, V>;
        andThenChar(arg0: Internal.Object2CharFunction_<V>): Internal.Int2CharFunction;
        replace(arg0: number, arg1: V): V;
        of<K, V>(): Internal.Map<K, V>;
        remove(arg0: number, arg1: any): boolean;
        /**
         * @deprecated
        */
        getOrDefault(arg0: any, arg1: V): V;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        abstract isEmpty(): boolean;
        entry<K, V>(arg0: K, arg1: V): Internal.Map$Entry<K, V>;
        computeIfAbsent(arg0: number, arg1: Internal.Int2ObjectFunction_<V>): V;
        composeReference<T>(arg0: Internal.Reference2IntFunction_<T>): Internal.Reference2ObjectFunction<T, V>;
        abstract int2ObjectEntrySet(): Internal.ObjectSet<Internal.Int2ObjectMap$Entry<V>>;
        /**
         * @deprecated
        */
        containsKey(arg0: any): boolean;
        abstract get(arg0: number): V;
        /**
         * @deprecated
        */
        put(arg0: number, arg1: V): V;
        andThenReference<T>(arg0: Internal.Object2ReferenceFunction_<V, T>): Internal.Int2ReferenceFunction<T>;
        replace(arg0: number, arg1: V, arg2: V): boolean;
        /**
         * @deprecated
        */
        remove(arg0: any): V;
        merge(arg0: number, arg1: V, arg2: Internal.BiFunction_<V, V, V>): V;
        computeIfAbsent(arg0: number, arg1: Internal.IntFunction_<V>): V;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V): Internal.Map<K, V>;
        composeInt(arg0: Internal.Int2IntFunction_): Internal.Int2ObjectFunction<V>;
        putIfAbsent(arg0: number, arg1: V): V;
        abstract putAll(arg0: Internal.Map_<number, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V): Internal.Map<K, V>;
        remove(arg0: any, arg1: any): boolean;
        abstract values(): Internal.ObjectCollection<V>;
        /**
         * @deprecated
        */
        computeIfAbsentPartial(arg0: number, arg1: Internal.Int2ObjectFunction_<V>): V;
        andThenShort(arg0: Internal.Object2ShortFunction_<V>): Internal.Int2ShortFunction;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V): Internal.Map<K, V>;
        composeShort(arg0: Internal.Short2IntFunction_): Internal.Short2ObjectFunction<V>;
        abstract size(): number;
        andThenLong(arg0: Internal.Object2LongFunction_<V>): Internal.Int2LongFunction;
        abstract hashCode(): number;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V, arg18: K, arg19: V): Internal.Map<K, V>;
        forEach(arg0: Internal.BiConsumer_<number, V>): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V, arg14: K, arg15: V, arg16: K, arg17: V): Internal.Map<K, V>;
        clear(): void;
        of<K, V>(arg0: K, arg1: V, arg2: K, arg3: V, arg4: K, arg5: V, arg6: K, arg7: V, arg8: K, arg9: V, arg10: K, arg11: V, arg12: K, arg13: V): Internal.Map<K, V>;
        abstract equals(arg0: any): boolean;
        replaceAll(arg0: Internal.BiFunction_<number, V, V>): void;
        /**
         * @deprecated
        */
        compose<T>(arg0: Internal.Function_<T, number>): Internal.Function<T, V>;
        get empty(): boolean
    }
    type Int2ObjectMap_<V> = Int2ObjectMap<V>;
    class ProtectionDomain {
        constructor(arg0: Internal.CodeSource_, arg1: Internal.PermissionCollection_)
        constructor(arg0: Internal.CodeSource_, arg1: Internal.PermissionCollection_, arg2: Internal.ClassLoader_, arg3: Internal.Principal_[])
        getPermissions(): Internal.PermissionCollection;
        getCodeSource(): Internal.CodeSource;
        getPrincipals(): Internal.Principal[];
        getClassLoader(): Internal.ClassLoader;
        implies(arg0: Internal.Permission_): boolean;
        staticPermissionsOnly(): boolean;
        get permissions(): Internal.PermissionCollection
        get codeSource(): Internal.CodeSource
        get principals(): Internal.Principal[]
        get classLoader(): Internal.ClassLoader
    }
    type ProtectionDomain_ = ProtectionDomain;
    interface SlottedStackStorage extends Internal.SlottedStorage<Internal.ItemVariant> {
        abstract extract(arg0: Internal.ItemVariant_, arg1: number, arg2: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        abstract getSlot(arg0: number): Internal.SingleSlotStorage<Internal.ItemVariant>;
        supportsInsertion(): boolean;
        isItemValid(slot: number, resource: Internal.ItemVariant_, count: number): boolean;
        abstract setStackInSlot(arg0: number, arg1: Internal.ItemStack_): void;
        supportsExtraction(): boolean;
        abstract getSlotCount(): number;
        extractSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        insertSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        abstract getStackInSlot(arg0: number): Internal.ItemStack;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        abstract getSlotLimit(arg0: number): number;
        abstract insert(arg0: Internal.ItemVariant_, arg1: number, arg2: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        asClass<T>(): Internal.Storage<T>;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        get version(): number
    }
    type SlottedStackStorage_ = SlottedStackStorage;
    interface WritableByteChannel extends Internal.Channel {
        abstract write(arg0: Internal.ByteBuffer_): number;
        abstract isOpen(): boolean;
        abstract close(): void;
        get open(): boolean
    }
    type WritableByteChannel_ = WritableByteChannel;
    interface TurtleCommand {
        abstract execute(arg0: Internal.ITurtleAccess_): Internal.TurtleCommandResult;
        (arg0: Internal.ITurtleAccess): Internal.TurtleCommandResult_;
    }
    type TurtleCommand_ = TurtleCommand;
    class SearedTankBlock extends Internal.SearedBlock implements Internal.BlockPickInteractionAware, Internal.LightEmissiveBlock, Internal.EntityBlock, Internal.TankBlockEntity$ITankBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_, capacity: number)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        getTicker<T extends Internal.BlockEntity>($$0: Internal.Level_, $$1: Internal.BlockState_, $$2: Internal.BlockEntityType_<T>): Internal.BlockEntityTicker<T>;
        getLightEmission(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_): number;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        getPickedStack(state: Internal.BlockState_, view: Internal.BlockGetter_, pos: BlockPos_, player: Internal.Player_, result: Internal.HitResult_): Internal.ItemStack;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        emi(): Internal.EmiStack;
        getCapacity(): number;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get capacity(): number
    }
    type SearedTankBlock_ = SearedTankBlock;
    class EnderEyeItem extends Internal.Item {
        constructor($$0: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type EnderEyeItem_ = EnderEyeItem;
    interface AbstractClientPlayerAccessor {
        abstract flywheel$getPlayerInfo(): Internal.PlayerInfo;
        (): Internal.PlayerInfo_;
    }
    type AbstractClientPlayerAccessor_ = AbstractClientPlayerAccessor;
    class RegistryObject <T> implements Internal.Supplier<T> {
        static empty<T>(): Internal.RegistryObject<T>;
        stream(): Internal.Stream<T>;
        static of<T>(id: ResourceLocation_, registry: Internal.Registry_<T>): Internal.RegistryObject<T>;
        ifPresent(consumer: Internal.Consumer_<T>): void;
        orElseGet(other: Internal.Supplier_<T>): T;
        flatMap<U>(mapper: Internal.Function_<T, Internal.Optional<U>>): Internal.Optional<U>;
        updateReference(registry: Internal.Registry_<T>): void;
        static create<T, U extends T>(name: ResourceLocation_, registryName: ResourceLocation_, modid: string): Internal.RegistryObject<U>;
        lazyMap<U>(mapper: Internal.Function_<T, U>): Internal.Supplier<U>;
        orElse(other: T): T;
        isPresent(): boolean;
        getId(): ResourceLocation;
        map<U>(mapper: Internal.Function_<T, U>): Internal.Optional<U>;
        orElseThrow<X extends Internal.Throwable>(exceptionSupplier: Internal.Supplier_<X>): T;
        filter(predicate: Internal.Predicate_<T>): this;
        get(): T;
        get present(): boolean
        get id(): ResourceLocation
    }
    type RegistryObject_<T> = RegistryObject<T>;
    interface ByteBufAllocatorMetricProvider {
        abstract metric(): Internal.ByteBufAllocatorMetric;
        (): Internal.ByteBufAllocatorMetric_;
    }
    type ByteBufAllocatorMetricProvider_ = ByteBufAllocatorMetricProvider;
    abstract class FloatBuffer extends Internal.Buffer implements Internal.Comparable<Internal.FloatBuffer> {
        put(arg0: number[], arg1: number, arg2: number): this;
        compareTo(arg0: Internal.FloatBuffer_): number;
        get(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        abstract slice(): this;
        static wrap(arg0: number[]): Internal.FloatBuffer;
        static allocate(arg0: number): Internal.FloatBuffer;
        compareTo(arg0: any): number;
        abstract compact(): this;
        get(arg0: number[], arg1: number, arg2: number): this;
        abstract order(): Internal.ByteOrder;
        put(arg0: number, arg1: Internal.FloatBuffer_, arg2: number, arg3: number): this;
        rewind(): this;
        mark(): this;
        put(arg0: number[]): this;
        mismatch(arg0: Internal.FloatBuffer_): number;
        abstract put(arg0: number): this;
        abstract get(): number;
        clear(): this;
        position(arg0: number): this;
        static wrap(arg0: number[], arg1: number, arg2: number): Internal.FloatBuffer;
        abstract duplicate(): this;
        put(arg0: number, arg1: number[]): this;
        get(arg0: number[]): this;
        put(arg0: Internal.FloatBuffer_): this;
        abstract put(arg0: number, arg1: number): this;
        put(arg0: number, arg1: number[], arg2: number, arg3: number): this;
        array(): number[];
        abstract get(arg0: number): number;
        get(arg0: number, arg1: number[]): this;
        abstract asReadOnlyBuffer(): this;
    }
    type FloatBuffer_ = FloatBuffer;
    class StructureBlockEntity$UpdateType extends Internal.Enum<Internal.StructureBlockEntity$UpdateType> {
        static values(): Internal.StructureBlockEntity$UpdateType[];
        static valueOf($$0: string): Internal.StructureBlockEntity$UpdateType;
        static readonly SAVE_AREA: Internal.StructureBlockEntity$UpdateType;
        static readonly UPDATE_DATA: Internal.StructureBlockEntity$UpdateType;
        static readonly LOAD_AREA: Internal.StructureBlockEntity$UpdateType;
        static readonly SCAN_AREA: Internal.StructureBlockEntity$UpdateType;
    }
    type StructureBlockEntity$UpdateType_ = "save_area" | StructureBlockEntity$UpdateType | "scan_area" | "update_data" | "load_area";
    class MechanicalCrafterBlockEntity extends Internal.KineticBlockEntity implements Internal.TransformableBlockEntity, Internal.SidedStorageBlockEntity {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getCountDownSpeed(): number;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        ejectWholeGrid(): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        getFluidStorage(side: Internal.Direction_): Internal.Storage<Internal.FluidVariant>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getTargetFace(world: Internal.Level_, pos: BlockPos_, state: Internal.BlockState_): Internal.BlockFace;
        tryInsert(): void;
        getInput(): Internal.ConnectedInputHandler$ConnectedInput;
        getInventory(): Internal.MechanicalCrafterBlockEntity$Inventory;
        dropItem(ejectPos: Vec3d_, stack: Internal.ItemStack_): void;
        onLoad(): void;
        getItemStorage(face: Internal.Direction_): Internal.Storage<Internal.ItemVariant>;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        getIcon(isPlayerSneaking: boolean): Internal.ItemStack;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        containedFluidTooltip(tooltip: Internal.List_<net.minecraft.network.chat.Component>, isPlayerSneaking: boolean, handler: Internal.Storage_<Internal.FluidVariant>): boolean;
        invalidateCaps(): void;
        checkCompletedRecipe(poweredStart: boolean): void;
        craftingItemPresent(): boolean;
        blockChanged(): void;
        connectivityChanged(): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        getTargetDirection(): Internal.Direction;
        asComponentProvider(): Internal.ComponentProvider;
        eject(): void;
        craftingItemOrCoverPresent(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        setScriptedResult(scriptedResult: Internal.ItemStack_): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        transform(be: Internal.BlockEntity_, transform: Internal.StructureTransform_): void;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getRenderBoundingBox(): Internal.AABB;
        get countDownSpeed(): number
        get input(): Internal.ConnectedInputHandler$ConnectedInput
        get inventory(): Internal.MechanicalCrafterBlockEntity$Inventory
        get targetDirection(): Internal.Direction
        get infiniteBoundingBox(): Internal.AABB
        set scriptedResult(scriptedResult: Internal.ItemStack_)
        get renderBoundingBox(): Internal.AABB
        input: Internal.ConnectedInputHandler$ConnectedInput;
    }
    type MechanicalCrafterBlockEntity_ = MechanicalCrafterBlockEntity;
    class ItemStymphalianArrow extends Internal.ArrowItem {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type ItemStymphalianArrow_ = ItemStymphalianArrow;
    class Activity {
        constructor($$0: string)
        getName(): string;
        get name(): string
        static readonly PLAY_DEAD: Internal.Activity;
        static readonly LONG_JUMP: Internal.Activity;
        static readonly RAM: Internal.Activity;
        static readonly WORK: Internal.Activity;
        static readonly SNIFF: Internal.Activity;
        static readonly ROAR: Internal.Activity;
        static readonly ADMIRE_ITEM: Internal.Activity;
        static readonly LAY_SPAWN: Internal.Activity;
        static readonly RIDE: Internal.Activity;
        static readonly MEET: Internal.Activity;
        static readonly SWIM: Internal.Activity;
        static readonly DIG: Internal.Activity;
        static readonly PLAY: Internal.Activity;
        static readonly FIGHT: Internal.Activity;
        static readonly AVOID: Internal.Activity;
        static readonly TONGUE: Internal.Activity;
        static readonly INVESTIGATE: Internal.Activity;
        static readonly PANIC: Internal.Activity;
        static readonly CORE: Internal.Activity;
        static readonly PRE_RAID: Internal.Activity;
        static readonly RAID: Internal.Activity;
        static readonly HIDE: Internal.Activity;
        static readonly CELEBRATE: Internal.Activity;
        static readonly EMERGE: Internal.Activity;
        static readonly IDLE: Internal.Activity;
        static readonly REST: Internal.Activity;
    }
    type Activity_ = Activity | Special.Activity;
    class AnvilUpgradeItem extends Internal.UpgradeItemBase<Internal.AnvilUpgradeWrapper> {
        constructor()
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        getType(): Internal.UpgradeType<Internal.AnvilUpgradeWrapper>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get type(): Internal.UpgradeType<Internal.AnvilUpgradeWrapper>
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
    }
    type AnvilUpgradeItem_ = AnvilUpgradeItem;
    interface IItemHandlerSimpleInserter extends Internal.SlottedStackStorage {
        abstract extract(arg0: Internal.ItemVariant_, arg1: number, arg2: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        exactView(resource: Internal.ItemVariant_): Internal.StorageView<Internal.ItemVariant>;
        abstract getSlot(arg0: number): Internal.SingleSlotStorage<Internal.ItemVariant>;
        supportsInsertion(): boolean;
        isItemValid(slot: number, resource: Internal.ItemVariant_, count: number): boolean;
        abstract setStackInSlot(arg0: number, arg1: Internal.ItemStack_): void;
        supportsExtraction(): boolean;
        abstract getSlotCount(): number;
        extractSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        insertSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        nonEmptyViews(): Internal.Iterable<Internal.StorageView<Internal.ItemVariant>>;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        abstract getStackInSlot(arg0: number): Internal.ItemStack;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        nonEmptyIterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        abstract getSlotLimit(arg0: number): number;
        abstract insert(arg0: Internal.ItemVariant_, arg1: number, arg2: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        asClass<T>(): Internal.Storage<T>;
        getSlots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        empty<T>(): Internal.Storage<T>;
        getVersion(): number;
        get slotCount(): number
        get slots(): Internal.List<Internal.SingleSlotStorage<Internal.ItemVariant>>
        get version(): number
    }
    type IItemHandlerSimpleInserter_ = IItemHandlerSimpleInserter;
    class ClientboundPlayerCombatEnterPacket implements Internal.Packet<Internal.ClientGamePacketListener> {
        constructor()
        constructor($$0: Internal.FriendlyByteBuf_)
        handle(arg0: Internal.PacketListener_): void;
        write($$0: Internal.FriendlyByteBuf_): void;
        handle($$0: Internal.ClientGamePacketListener_): void;
        isSkippable(): boolean;
        get skippable(): boolean
    }
    type ClientboundPlayerCombatEnterPacket_ = ClientboundPlayerCombatEnterPacket;
    interface ITintable {
        abstract getMainColor(): number;
        abstract getAccentColor(): number;
        abstract setColors(arg0: number, arg1: number): void;
        get mainColor(): number
        get accentColor(): number
    }
    type ITintable_ = ITintable;
    class MaterialFluidRecipe implements Internal.ICustomOutputRecipe<Internal.ICastingContainer> {
        constructor(id: ResourceLocation_, fluid: slimeknights.mantle.recipe.ingredient.FluidIngredient_, temperature: number, inputId: Internal.MaterialVariantId_, outputId: Internal.MaterialVariantId_)
        getGroup(): string;
        getToastSymbol(): Internal.ItemStack;
        getSchema(): Internal.RecipeSchema;
        getInput(): Internal.MaterialVariant;
        /**
         * @deprecated
        */
        assemble(inv: Internal.ICastingContainer_, registryAccess: Internal.RegistryAccess_): Internal.ItemStack;
        getSerializer(): Internal.RecipeSerializer<any>;
        getId(): ResourceLocation;
        "handler$cfb000$fabric-item-api-v1$captureStack"(inventory: net.minecraft.world.Container_, cir: Internal.CallbackInfoReturnable_<any>, defaultedList: Internal.NonNullList_<any>, i: number): void;
        matches(arg0: net.minecraft.world.Container_, arg1: Internal.Level_): boolean;
        getMod(): string;
        matches(inv: Internal.ICastingContainer_): boolean;
        getIngredients(): Internal.NonNullList<Internal.Ingredient>;
        isSpecial(): boolean;
        getRemainingItems($$0: Internal.ICastingContainer_): Internal.NonNullList<Internal.ItemStack>;
        getOutput(): Internal.MaterialVariant;
        matches(inv: Internal.ICastingContainer_, worldIn: Internal.Level_): boolean;
        hasOutput(match: Internal.ReplacementMatch_): boolean;
        /**
         * @deprecated
        */
        getResultItem(access: Internal.RegistryAccess_): Internal.ItemStack;
        /**
         * @deprecated
        */
        canCraftInDimensions(width: number, height: number): boolean;
        getFluids(): Internal.List<Internal.FluidStack>;
        showNotification(): boolean;
        replaceInput(match: Internal.ReplacementMatch_, with_: Internal.InputReplacement_): boolean;
        getType(): ResourceLocation;
        getFluidAmount(fluid: Internal.Fluid_): number;
        setGroup(group: string): void;
        getOrCreateId(): ResourceLocation;
        hasInput(match: Internal.ReplacementMatch_): boolean;
        isIncomplete(): boolean;
        getTemperature(): number;
        replaceOutput(match: Internal.ReplacementMatch_, with_: Internal.OutputReplacement_): boolean;
        get group(): string
        get toastSymbol(): Internal.ItemStack
        get schema(): Internal.RecipeSchema
        get input(): Internal.MaterialVariant
        get serializer(): Internal.RecipeSerializer<any>
        get id(): ResourceLocation
        get mod(): string
        get ingredients(): Internal.NonNullList<Internal.Ingredient>
        get special(): boolean
        get output(): Internal.MaterialVariant
        get fluids(): Internal.List<Internal.FluidStack>
        get type(): ResourceLocation
        set group(group: string)
        get orCreateId(): ResourceLocation
        get incomplete(): boolean
        get temperature(): number
    }
    type MaterialFluidRecipe_ = MaterialFluidRecipe;
    class ItemObject <I extends Internal.ItemLike> implements Internal.Supplier<I>, Internal.ItemLike {
        constructor(object: io.github.fabricators_of_create.porting_lib.util.RegistryObject_<I>)
        constructor(entry: I)
        constructor(entry: Internal.Supplier_<I>, name: ResourceLocation_)
        get(): any;
        emi(amount: number): Internal.EmiStack;
        getOrNull(): I;
        getRegistryName(): ResourceLocation;
        asItem(): Internal.Item;
        emi(): Internal.EmiStack;
        get orNull(): I
        get registryName(): ResourceLocation
    }
    type ItemObject_<I extends Internal.ItemLike> = ItemObject<I>;
    class SlimeFluid$Flowing extends Internal.SlimeFluid {
        constructor(properties: any_)
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type SlimeFluid$Flowing_ = SlimeFluid$Flowing;
    class Either$Mu <R> implements Internal.K1 {
        constructor()
    }
    type Either$Mu_<R> = Either$Mu<R>;
    class HeadstockBlockEntity extends Internal.DyeableBlockEntity implements Internal.IMaterialAdaptingBuffer {
        constructor(type: Internal.BlockEntityType_<any>, pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        write(compound: Internal.CompoundTag_, clientPacket: boolean): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getInfiniteBoundingBox(): Internal.AABB;
        applyMaterialIfValid(stack: Internal.ItemStack_): Internal.InteractionResult;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        getMaterial(): Internal.BlockState;
        self(): Internal.BlockEntity;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        get infiniteBoundingBox(): Internal.AABB
        get material(): Internal.BlockState
    }
    type HeadstockBlockEntity_ = HeadstockBlockEntity;
    class ContinuationWhile$WhileType implements Internal.ContinuationFrame$Type<Internal.ContinuationWhile> {
        deserializeFromNBT(tag: Internal.CompoundTag_, world: Internal.ServerLevel_): Internal.ContinuationWhile;
        static readonly INSTANCE: Internal.ContinuationWhile$WhileType;
    }
    type ContinuationWhile$WhileType_ = ContinuationWhile$WhileType;
    interface MinecraftServerAccessor {
        abstract port_lib$getServerResources(): Internal.MinecraftServer$ReloadableResources;
        abstract port_lib$getStorageSource(): Internal.LevelStorageSource$LevelStorageAccess;
    }
    type MinecraftServerAccessor_ = MinecraftServerAccessor;
    class FilterUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.FilterUpgradeWrapper, Internal.FilterUpgradeItem> implements Internal.IIOFilterUpgrade, Internal.IContentsFilteredUpgrade {
        constructor(storageWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        getInputFilter(): Internal.Optional<Internal.FilterLogic>;
        hideSettingsTab(): boolean;
        getDirection(): net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction;
        getFilterLogic(): Internal.FilterLogic;
        onAdded(): void;
        setDirection(direction: net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction_): void;
        getOutputFilter(): Internal.Optional<Internal.FilterLogic>;
        onBeforeRemoved(): void;
        get inputFilter(): Internal.Optional<Internal.FilterLogic>
        get direction(): net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction
        get filterLogic(): Internal.FilterLogic
        set direction(direction: net.p3pp3rf1y.sophisticatedcore.upgrades.filter.Direction_)
        get outputFilter(): Internal.Optional<Internal.FilterLogic>
    }
    type FilterUpgradeWrapper_ = FilterUpgradeWrapper;
    class BlockLootEventJS extends Internal.LootEventJS {
        constructor(c: Internal.Map_<ResourceLocation, Internal.JsonElement>)
        addBlock(blocks: BlockStatePredicate_, b: Internal.Consumer_<Internal.LootBuilder>): void;
        addSimpleBlock(blocks: BlockStatePredicate_, item: Internal.ItemStack_): void;
        modifyBlock(blocks: BlockStatePredicate_, b: Internal.Consumer_<Internal.LootBuilder>): void;
        addSimpleBlock(blocks: BlockStatePredicate_): void;
        build(blocks: BlockStatePredicate_, b: Internal.Consumer_<Internal.LootBuilder>): void;
    }
    type BlockLootEventJS_ = BlockLootEventJS;
    class HopperBlockEntity extends Internal.RandomizableContainerBlockEntity implements Internal.SectionedEntityMovementListener, Internal.InventoryChangeTracker, Internal.SleepingBlockEntity, Internal.InventoryChangeListener, Internal.UpdateReceiver, Internal.Hopper, Internal.LithiumInventory {
        constructor($$0: BlockPos_, $$1: Internal.BlockState_)
        stopOpen($$0: Internal.Player_): void;
        stopListenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        static tryClear($$0: any): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        setStackInSlot(slot: number, stack: Internal.ItemStack_): void;
        clear(ingredient: Internal.Ingredient_): void;
        find(): number;
        hasAnyOf($$0: Internal.Set_<Internal.Item>): boolean;
        getSlots(): number;
        getExtractBlockInventory(world: Internal.Level_): net.minecraft.world.Container;
        isSleeping(): boolean;
        setChanged(): void;
        onLoad(): void;
        sleepOnlyCurrentTick(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        hasAnyMatching($$0: Internal.Predicate_<Internal.ItemStack>): boolean;
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        setInventoryLithium(arg0: Internal.NonNullList_<any>): void;
        getSleepingTicker(): Internal.TickingBlockEntity;
        invalidateCaps(): void;
        kjs$self(): net.minecraft.world.Container;
        getInventoryLithium(): Internal.NonNullList<any>;
        getWidth(): number;
        getSlotLimit(slot: number): number;
        getMaxStackSize(): number;
        asComponentProvider(): Internal.ComponentProvider;
        setTickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_): void;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_): boolean;
        hasCustomName(): boolean;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        static addItem($$0: net.minecraft.world.Container_, $$1: Internal.ItemEntity_): boolean;
        getSuckShape(): Internal.VoxelShape;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        wakeUpNow(): void;
        fabric_onTransfer(slot: number, transaction: Internal.TransactionContext_): void;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        setTicker(delegate: Internal.TickingBlockEntity_): void;
        getTickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor;
        getInsertBlockInventory(world: Internal.Level_, hopperState: Internal.BlockState_): net.minecraft.world.Container;
        handleEntityMovement(category: typeof any): void;
        getLevelY(): number;
        handleInventoryRemoved(inventory: net.minecraft.world.Container_): void;
        isItemValid(slot: number, stack: Internal.ItemStack_): boolean;
        count(ingredient: Internal.Ingredient_): number;
        count(): number;
        emitCallbackReplaced(): void;
        setTransferCooldown(currentTime: number): void;
        countItem($$0: Internal.Item_): number;
        static pushItemsTick($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.HopperBlockEntity_): void;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        invalidateCacheOnNeighborUpdate(fromDirection: Internal.Direction_): void;
        isEmpty(): boolean;
        handleComparatorAdded(inventory: net.minecraft.world.Container_): boolean;
        invalidateCacheOnNeighborUpdate(fromAbove: boolean): void;
        startOpen($$0: Internal.Player_): void;
        canPlaceItem($$0: number, $$1: Internal.ItemStack_): boolean;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        extractItem(slot: number, amount: number, simulate: boolean): Internal.ItemStack;
        getBlock(level: Internal.Level_): Internal.BlockContainerJS;
        handler$elj003$lithium$setInventoryStackListReplacement(list: Internal.NonNullList_<any>, ci: Internal.CallbackInfo_): void;
        static entityInside($$0: Internal.Level_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Entity_, $$4: Internal.HopperBlockEntity_): void;
        shouldCloseCurrentScreen(): boolean;
        static stillValidBlockEntity($$0: Internal.BlockEntity_, $$1: Internal.Player_, $$2: number): boolean;
        canReceiveTransferCooldown(): boolean;
        getStackInSlot(slot: number): Internal.ItemStack;
        listenForContentChangesOnce(stackList: Internal.LithiumStackList_, inventoryChangeListener: Internal.InventoryChangeListener_): void;
        getHeight(): number;
        static suckInItems($$0: Internal.Level_, $$1: Internal.Hopper_): boolean;
        countNonEmpty(): number;
        listenForMajorInventoryChanges(inventoryChangeListener: Internal.InventoryChangeListener_): void;
        asContainer(): net.minecraft.world.Container;
        handleStackListReplaced(inventory: net.minecraft.world.Container_): void;
        getAllItems(): Internal.List<Internal.ItemStack>;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        static addItem($$0: net.minecraft.world.Container_, $$1: net.minecraft.world.Container_, $$2: Internal.ItemStack_, $$3: Internal.Direction_): Internal.ItemStack;
        static getItemsAtAndAbove(world: Internal.Level_, hopper: Internal.Hopper_): Internal.List<any>;
        generateLootLithium(): void;
        canTakeItem($$0: net.minecraft.world.Container_, $$1: number, $$2: Internal.ItemStack_): boolean;
        insertItem(stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        handleInventoryContentModified(inventory: net.minecraft.world.Container_): void;
        startSleeping(): boolean;
        insertItem(slot: number, stack: Internal.ItemStack_, simulate: boolean): Internal.ItemStack;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        isMutable(): boolean;
        clear(): void;
        find(ingredient: Internal.Ingredient_): number;
        setSleepingTicker(sleepingTicker: Internal.TickingBlockEntity_): void;
        getLevelX(): number;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        getInsertInventory(world: Internal.Level_, hopperState: Internal.BlockState_): net.minecraft.world.Container;
        static getContainerAt($$0: Internal.Level_, $$1: BlockPos_): net.minecraft.world.Container;
        getLevelZ(): number;
        countNonEmpty(ingredient: Internal.Ingredient_): number;
        get slots(): number
        get sleeping(): boolean
        set inventoryLithium(arg0: Internal.NonNullList_<any>)
        get sleepingTicker(): Internal.TickingBlockEntity
        get inventoryLithium(): Internal.NonNullList<any>
        get width(): number
        get maxStackSize(): number
        set tickWrapper(tickWrapper: Internal.WrappedBlockEntityTickInvokerAccessor_)
        get suckShape(): Internal.VoxelShape
        set ticker(delegate: Internal.TickingBlockEntity_)
        get tickWrapper(): Internal.WrappedBlockEntityTickInvokerAccessor
        get levelY(): number
        set transferCooldown(currentTime: number)
        get empty(): boolean
        get height(): number
        get allItems(): Internal.List<Internal.ItemStack>
        get mutable(): boolean
        set sleepingTicker(sleepingTicker: Internal.TickingBlockEntity_)
        get levelX(): number
        get levelZ(): number
        static readonly HOPPER_CONTAINER_SIZE: 5;
        static readonly MOVE_ITEM_SPEED: 8;
    }
    type HopperBlockEntity_ = HopperBlockEntity;
    class AttributeSupplier {
        constructor($$0: Internal.Map_<Internal.Attribute, Internal.AttributeInstance>)
        hasAttribute($$0: Internal.Attribute_): boolean;
        getBaseValue($$0: Internal.Attribute_): number;
        getValue($$0: Internal.Attribute_): number;
        hasModifier($$0: Internal.Attribute_, $$1: Internal.UUID_): boolean;
        createInstance($$0: Internal.Consumer_<Internal.AttributeInstance>, $$1: Internal.Attribute_): Internal.AttributeInstance;
        getModifierValue($$0: Internal.Attribute_, $$1: Internal.UUID_): number;
        static builder(): Internal.AttributeSupplier$Builder;
    }
    type AttributeSupplier_ = AttributeSupplier;
    class ConjuredDuckyBlockEntity extends Internal.BlockEntity {
        constructor(pos: BlockPos_, state: Internal.BlockState_)
        getComponent<C extends dev.onyxstudios.cca.api.v3.component.Component>(key: Internal.ComponentKey_<C>): C;
        invalidateCaps(): void;
        syncComponent(key: Internal.ComponentKey_<any>): void;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_, predicate: Internal.PlayerSyncPredicate_): void;
        asComponentProvider(): Internal.ComponentProvider;
        modifyAttached<A>(type: Internal.AttachmentType_<A>, modifier: Internal.UnaryOperator_<A>): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>): A;
        syncComponent(key: Internal.ComponentKey_<any>, packetWriter: Internal.ComponentPacketWriter_): void;
        getAttachedOrGet<A>(type: Internal.AttachmentType_<A>, defaultValue: Internal.Supplier_<A>): A;
        getColorizer(): Internal.FrozenPigment;
        static transfer(original: Internal.AttachmentTarget_, target: Internal.AttachmentTarget_, isDeath: boolean): void;
        getAttachedOrElse<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrCreate<A>(type: Internal.AttachmentType_<A>, initializer: Internal.Supplier_<A>): A;
        etf$getETFRenderState(): Internal.ETFEntityRenderState;
        onLoad(): void;
        getAttachedOrSet<A>(type: Internal.AttachmentType_<A>, defaultValue: A): A;
        getAttachedOrThrow<A>(type: Internal.AttachmentType_<A>): A;
        removeAttached<A>(type: Internal.AttachmentType_<A>): A;
        setColorizer(colorizer: Internal.FrozenPigment_): void;
        get colorizer(): Internal.FrozenPigment
        set colorizer(colorizer: Internal.FrozenPigment_)
        static readonly TAG_COLORIZER: "tag_colorizer";
    }
    type ConjuredDuckyBlockEntity_ = ConjuredDuckyBlockEntity;
    class GravityNormalizerBlock extends Internal.SidedMachineBlock {
        constructor(properties: Internal.BlockBehaviour$Properties_)
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getBlockStates(): Internal.List<Internal.BlockState>;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        emi(amount: number): Internal.EmiStack;
        setRequiresTool(v: boolean): void;
        emi(): Internal.EmiStack;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        set destroySpeed(v: number)
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        static readonly SOUTH_SIDE_SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly TOP_SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly EAST_SIDE_SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly WEST_SIDE_SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly NORTH_SIDE_SHAPE: Internal.VoxelShapeSimpleCube;
        static readonly BOTTOM_SHAPE: Internal.VoxelShapeSimpleCube;
    }
    type GravityNormalizerBlock_ = GravityNormalizerBlock;
    abstract class AttachedActorBlock extends Internal.HorizontalDirectionalBlock implements Internal.ProperWaterloggedBlock, com.simibubi.create.content.equipment.wrench.IWrenchable {
        canPlaceLiquid($$0: Internal.BlockGetter_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.Fluid_): boolean;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        updateWater(level: Internal.LevelAccessor_, state: Internal.BlockState_, pos: BlockPos_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        pickupBlock($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_): Internal.ItemStack;
        getPickupSound(): Internal.Optional<Internal.SoundEvent>;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        fluidState(state: Internal.BlockState_): Internal.FluidState;
        setRequiresTool(v: boolean): void;
        static withWater(level: Internal.LevelAccessor_, placementState: Internal.BlockState_, pos: BlockPos_): Internal.BlockState;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        withWater(placementState: Internal.BlockState_, ctx: Internal.BlockPlaceContext_): Internal.BlockState;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        placeLiquid($$0: Internal.LevelAccessor_, $$1: BlockPos_, $$2: Internal.BlockState_, $$3: Internal.FluidState_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get pickupSound(): Internal.Optional<Internal.SoundEvent>
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type AttachedActorBlock_ = AttachedActorBlock;
    class FluidTankItem extends Internal.BlockItem {
        constructor(p_i48527_1_: Internal.Block_, p_i48527_2_: Internal.Item$Properties_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        static checkPlacingNbt(ctx: Internal.BlockPlaceContext_): boolean;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        setAttackSpeed(attackSpeed: number): void;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        emi(amount: number): Internal.EmiStack;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeFromBlockToItemMap(blockToItemMap: Internal.Map_<Internal.Block, Internal.Item>, itemIn: Internal.Item_): void;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        set digSpeed(speed: number)
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static IS_PLACING_NBT: false;
    }
    type FluidTankItem_ = FluidTankItem;
    interface IContentsFilteredUpgrade extends Internal.IFilteredUpgrade {
        abstract getFilterLogic(): Internal.ContentsFilterLogic;
        get filterLogic(): Internal.ContentsFilterLogic
        (): Internal.ContentsFilterLogic_;
    }
    type IContentsFilteredUpgrade_ = IContentsFilteredUpgrade;
    class DigitalAdapterBlock extends Internal.Block implements com.simibubi.create.content.equipment.wrench.IWrenchable, Internal.IBE<Internal.DigitalAdapterBlockEntity> {
        constructor(props: Internal.BlockBehaviour$Properties_)
        newBlockEntity(pos: BlockPos_, state: Internal.BlockState_): Internal.BlockEntity;
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        static onRemove(blockState: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, newBlockState: Internal.BlockState_): void;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        getBlockEntityOptional(world: Internal.BlockGetter_, pos: BlockPos_): Internal.Optional<Internal.DigitalAdapterBlockEntity>;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        onBlockEntityUse(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Function_<Internal.DigitalAdapterBlockEntity, Internal.InteractionResult>): Internal.InteractionResult;
        getBlockEntityType(): Internal.BlockEntityType<Internal.DigitalAdapterBlockEntity>;
        withBlockEntityDo(world: Internal.BlockGetter_, pos: BlockPos_, action: Internal.Consumer_<Internal.DigitalAdapterBlockEntity>): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        getListener<T extends Internal.BlockEntity>($$0: Internal.ServerLevel_, $$1: T): Internal.GameEventListener;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        getBlockEntityClass(): typeof Internal.DigitalAdapterBlockEntity;
        getTicker<S extends Internal.BlockEntity>(p_153212_: Internal.Level_, p_153213_: Internal.BlockState_, p_153214_: Internal.BlockEntityType_<S>): Internal.BlockEntityTicker<S>;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        getBlockEntity(worldIn: Internal.BlockGetter_, pos: BlockPos_): Internal.DigitalAdapterBlockEntity;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
        get blockEntityType(): Internal.BlockEntityType<Internal.DigitalAdapterBlockEntity>
        get blockEntityClass(): typeof Internal.DigitalAdapterBlockEntity
    }
    type DigitalAdapterBlock_ = DigitalAdapterBlock;
    class SchematicTableBlockEntity$SchematicTableInventory extends io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler {
        constructor(this$0: Internal.SchematicTableBlockEntity_)
        supportsInsertion(): boolean;
        isItemValid(slot: number, resource: Internal.ItemVariant_, count: number): boolean;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        isItemValid(slot: number, resource: Internal.ItemVariant_): boolean;
        static asClass<T>(): Internal.Storage<T>;
        supportsExtraction(): boolean;
        extractSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        insertSlot(slot: number, resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateInsert(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        forEach(arg0: Internal.Consumer_<Internal.StorageView<T>>): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        simulateExtract(resource: Internal.ItemVariant_, maxAmount: number, transaction: Internal.TransactionContext_): number;
        serializeNBT(): Internal.Tag;
        getVersion(): number;
        spliterator(): Internal.Spliterator<Internal.StorageView<T>>;
        iterator(): Internal.Iterator<Internal.StorageView<Internal.ItemVariant>>;
        get version(): number
    }
    type SchematicTableBlockEntity$SchematicTableInventory_ = SchematicTableBlockEntity$SchematicTableInventory;
    interface PlayerDestroyBlock {
        onDestroyedByPlayer(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, player: Internal.Player_, willHarvest: boolean, fluid: Internal.FluidState_): boolean;
    }
    type PlayerDestroyBlock_ = PlayerDestroyBlock;
    interface FloatProviderType <P extends Internal.FloatProvider> {
        abstract codec(): Internal.Codec<P>;
        register<P extends Internal.FloatProvider>($$0: string, $$1: Internal.Codec_<P>): this;
        (): Internal.Codec_<P>;
        readonly UNIFORM: Internal.FloatProviderType<Internal.UniformFloat>;
        readonly CLAMPED_NORMAL: Internal.FloatProviderType<Internal.ClampedNormalFloat>;
        readonly TRAPEZOID: Internal.FloatProviderType<Internal.TrapezoidFloat>;
        readonly CONSTANT: Internal.FloatProviderType<Internal.ConstantFloat>;
    }
    type FloatProviderType_<P extends Internal.FloatProvider> = FloatProviderType<P> | Special.FloatProviderType;
    interface AuthenticationService {
        abstract createProfileRepository(): Internal.GameProfileRepository;
        abstract createMinecraftSessionService(): Internal.MinecraftSessionService;
        abstract createUserAuthentication(arg0: Internal.Agent_): Internal.UserAuthentication;
    }
    type AuthenticationService_ = AuthenticationService;
    interface CapacityEnchantment$ICapacityEnchantable {
    }
    type CapacityEnchantment$ICapacityEnchantable_ = CapacityEnchantment$ICapacityEnchantable;
    class UnplaceableFluid extends Internal.Fluid {
        constructor(bucket: Internal.Supplier_<Internal.Item>, builder: Internal.FluidAttributes$Builder_)
        createAttributes(): Internal.FluidAttributes;
        arch$holder(): Internal.Holder<Internal.Fluid>;
        arch$registryName(): ResourceLocation;
    }
    type UnplaceableFluid_ = UnplaceableFluid;
    class BelowZeroRetrogen {
        applyBedrockMask($$0: Internal.ProtoChunk_): void;
        hasBedrockHole($$0: number, $$1: number): boolean;
        static getBiomeResolver($$0: Internal.BiomeResolver_, $$1: Internal.ChunkAccess_): Internal.BiomeResolver;
        hasBedrockHoles(): boolean;
        targetStatus(): Internal.ChunkStatus;
        static read($$0: Internal.CompoundTag_): Internal.BelowZeroRetrogen;
        static replaceOldBedrock($$0: Internal.ProtoChunk_): void;
        static readonly UPGRADE_HEIGHT_ACCESSOR: Internal.LevelHeightAccessor;
        static readonly CODEC: Internal.Codec<Internal.BelowZeroRetrogen>;
    }
    type BelowZeroRetrogen_ = BelowZeroRetrogen;
    interface EntityEvents$LightingStrike {
        abstract onEntityStruckByLightning(arg0: Internal.Entity_, arg1: Internal.LightningBolt_): boolean;
        (arg0: Internal.Entity, arg1: Internal.LightningBolt): boolean;
    }
    type EntityEvents$LightingStrike_ = EntityEvents$LightingStrike;
    interface ChronoPeriod extends Internal.TemporalAmount {
        abstract addTo(arg0: Internal.Temporal_): Internal.Temporal;
        abstract getChronology(): Internal.Chronology;
        abstract toString(): string;
        negated(): this;
        abstract multipliedBy(arg0: number): this;
        isZero(): boolean;
        abstract normalized(): this;
        abstract subtractFrom(arg0: Internal.Temporal_): Internal.Temporal;
        abstract hashCode(): number;
        between(arg0: Internal.ChronoLocalDate_, arg1: Internal.ChronoLocalDate_): this;
        abstract plus(arg0: Internal.TemporalAmount_): this;
        abstract getUnits(): Internal.List<Internal.TemporalUnit>;
        abstract minus(arg0: Internal.TemporalAmount_): this;
        abstract get(arg0: Internal.TemporalUnit_): number;
        abstract equals(arg0: any): boolean;
        isNegative(): boolean;
        get chronology(): Internal.Chronology
        get zero(): boolean
        get units(): Internal.List<Internal.TemporalUnit>
        get negative(): boolean
    }
    type ChronoPeriod_ = ChronoPeriod;
    class DepositUpgradeWrapper extends Internal.UpgradeWrapperBase<Internal.DepositUpgradeWrapper, Internal.DepositUpgradeItem> implements Internal.IFilteredUpgrade, Internal.IItemHandlerInteractionUpgrade {
        constructor(backpackWrapper: Internal.IStorageWrapper_, upgrade: Internal.ItemStack_, upgradeSaveHandler: Internal.Consumer_<Internal.ItemStack>)
        canBeDisabled(): boolean;
        getFilterLogic(): Internal.DepositFilterLogic;
        onHandlerInteract(itemHandler: Internal.SlottedStorage_<Internal.ItemVariant>, player: Internal.Player_): void;
        hideSettingsTab(): boolean;
        onAdded(): void;
        onBeforeRemoved(): void;
        get filterLogic(): Internal.DepositFilterLogic
    }
    type DepositUpgradeWrapper_ = DepositUpgradeWrapper;
    class PickupUpgradeItem extends Internal.UpgradeItemBase<Internal.PickupUpgradeWrapper> {
        constructor(filterSlotCount: Internal.IntSupplier_, upgradeTypeLimitConfig: any_)
        hasCustomEntity(stack: Internal.ItemStack_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        allowContinuingBlockBreaking(player: Internal.Player_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        getRecipeRemainder(stack: Internal.ItemStack_): Internal.ItemStack;
        getType(): Internal.UpgradeType<Internal.PickupUpgradeWrapper>;
        onArmorTick(stack: Internal.ItemStack_, level: Internal.Level_, player: Internal.Player_): void;
        setDigSpeed(speed: number): void;
        onItemUseFirst(stack: Internal.ItemStack_, context: Internal.UseOnContext_): Internal.InteractionResult;
        checkThisForConflictsWithExistingUpgrades(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, excludeUpgradeSlot: number): Internal.UpgradeSlotChangeResult;
        getLightColor(player: Internal.Player_, stack: Internal.ItemStack_): Vec3f;
        getFilterSlotCount(): number;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, player: Internal.Player_): Internal.UpgradeSlotChangeResult;
        setAttackSpeed(attackSpeed: number): void;
        getCleanedUpgradeStack(upgradeStack: Internal.ItemStack_): Internal.ItemStack;
        arch$registryName(): ResourceLocation;
        setAttackDamage(attackDamage: number): void;
        getAttributeModifiers(stack: Internal.ItemStack_, slot: Internal.EquipmentSlot_): Internal.Multimap<Internal.Attribute, Internal.AttributeModifier>;
        static port_lib$getPlayerPOVHitResult(level: Internal.Level_, player: Internal.Player_, fluidMode: Internal.ClipContext$Fluid_): Internal.BlockHitResult;
        arch$holder(): Internal.Holder<Internal.Item>;
        getMod(): string;
        static getBaseAttackDamageUUID(): Internal.UUID;
        createEntity(level: Internal.Level_, location: Internal.Entity_, stack: Internal.ItemStack_): Internal.Entity;
        getAttributes(attribute: Internal.Attribute_): Internal.List<Internal.AttributeModifier>;
        getInventoryColumnsTaken(): number;
        setArmorProtection(armorProtection: number): void;
        getLightEmission(player: Internal.Player_, stack: Internal.ItemStack_): number;
        getCreativeTab(): string;
        setArmorToughness(armorToughness: number): void;
        onDroppedByPlayer(stack: Internal.ItemStack_, player: Internal.Player_): boolean;
        canSwapUpgradeFor(upgradeStackToPut: Internal.ItemStack_, upgradeSlot: number, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        allowNbtUpdateAnimation(player: Internal.Player_, hand: Internal.InteractionHand_, oldStack: Internal.ItemStack_, newStack: Internal.ItemStack_): boolean;
        checkExtraInsertConditions(upgradeStack: Internal.ItemStack_, storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean, upgradeInSlot: Internal.IUpgradeItem_<any>): Internal.UpgradeSlotChangeResult;
        getDefaultTooltipHideFlags(stack: Internal.ItemStack_): number;
        getCreatorModId(itemStack: Internal.ItemStack_): string;
        canAddUpgradeTo(storageWrapper: Internal.IStorageWrapper_, upgradeStack: Internal.ItemStack_, firstLevelStorage: boolean, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        emi(amount: number): Internal.EmiStack;
        getUpgradeGroup(): Internal.UpgradeGroup;
        canRemoveUpgradeFrom(storageWrapper: Internal.IStorageWrapper_, isClientSide: boolean): Internal.UpgradeSlotChangeResult;
        addAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_, name: string, d: number, operation: Internal.AttributeModifier$Operation_): void;
        emi(): Internal.EmiStack;
        isSuitableFor(stack: Internal.ItemStack_, state: Internal.BlockState_): boolean;
        onLeftClickEntity(stack: Internal.ItemStack_, player: Internal.Player_, entity: Internal.Entity_): boolean;
        getDigSpeed(): number;
        setTier(c: Internal.Consumer_<Internal.MutableToolTier>): void;
        setFoodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>): void;
        onBlockStartBreak(itemstack: Internal.ItemStack_, pos: BlockPos_, player: Internal.Player_): boolean;
        removeAttribute(attribute: Internal.Attribute_, uuid: Internal.UUID_): void;
        setArmorKnockbackResistance(knockbackResistance: number): void;
        get type(): Internal.UpgradeType<Internal.PickupUpgradeWrapper>
        set digSpeed(speed: number)
        get filterSlotCount(): number
        set attackSpeed(attackSpeed: number)
        set attackDamage(attackDamage: number)
        get mod(): string
        get baseAttackDamageUUID(): Internal.UUID
        get inventoryColumnsTaken(): number
        set armorProtection(armorProtection: number)
        get creativeTab(): string
        set armorToughness(armorToughness: number)
        get upgradeGroup(): Internal.UpgradeGroup
        get digSpeed(): number
        set tier(c: Internal.Consumer_<Internal.MutableToolTier>)
        set foodProperties(consumer: Internal.Consumer_<Internal.FoodBuilder>)
        set armorKnockbackResistance(knockbackResistance: number)
        static readonly TYPE: Internal.UpgradeType<Internal.PickupUpgradeWrapper>;
    }
    type PickupUpgradeItem_ = PickupUpgradeItem;
    class FuelTankBlock$Shape extends Internal.Enum<Internal.FuelTankBlock$Shape> implements Internal.StringRepresentable {
        static fromEnum<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>): Internal.StringRepresentable$EnumCodec<E>;
        static keys($$0: Internal.StringRepresentable_[]): Internal.Keyable;
        static fromEnumWithMapping<E extends Internal.Enum<E> & Internal.StringRepresentable>($$0: Internal.Supplier_<E[]>, $$1: Internal.Function_<string, string>): Internal.StringRepresentable$EnumCodec<E>;
        getSerializedName(): string;
        static values(): Internal.FuelTankBlock$Shape[];
        static valueOf(name: string): Internal.FuelTankBlock$Shape;
        get serializedName(): string
        static readonly WINDOW_NW: Internal.FuelTankBlock$Shape;
        static readonly PLAIN: Internal.FuelTankBlock$Shape;
        static readonly WINDOW_SW: Internal.FuelTankBlock$Shape;
        static readonly WINDOW: Internal.FuelTankBlock$Shape;
        static readonly WINDOW_NE: Internal.FuelTankBlock$Shape;
        static readonly WINDOW_SE: Internal.FuelTankBlock$Shape;
    }
    type FuelTankBlock$Shape_ = "window_nw" | "window_ne" | "window" | "window_sw" | "plain" | "window_se" | FuelTankBlock$Shape;
    class StyleConstants$ColorConstants extends Internal.StyleConstants implements Internal.AttributeSet$CharacterAttribute, Internal.AttributeSet$ColorAttribute {
    }
    type StyleConstants$ColorConstants_ = StyleConstants$ColorConstants;
    class IconSet extends Internal.Enum<Internal.IconSet> {
        static valueOf($$0: string): Internal.IconSet;
        getMacIcon($$0: Internal.PackResources_): Internal.IoSupplier<Internal.InputStream>;
        getStandardIcons($$0: Internal.PackResources_): Internal.List<Internal.IoSupplier<Internal.InputStream>>;
        static values(): Internal.IconSet[];
        static readonly RELEASE: Internal.IconSet;
        static readonly SNAPSHOT: Internal.IconSet;
    }
    type IconSet_ = "release" | "snapshot" | IconSet;
    interface PrimitiveIterator$OfDouble extends Internal.PrimitiveIterator<number, Internal.DoubleConsumer> {
        forEachRemaining(arg0: any): void;
        forEachRemaining(arg0: Internal.Consumer_<number>): void;
        remove(): void;
        next(): any;
        forEachRemaining(arg0: Internal.DoubleConsumer_): void;
        abstract nextDouble(): number;
        abstract hasNext(): boolean;
    }
    type PrimitiveIterator$OfDouble_ = PrimitiveIterator$OfDouble;
    class VeryBiasedToBottomHeight extends Internal.HeightProvider {
        static of($$0: Internal.VerticalAnchor_, $$1: Internal.VerticalAnchor_, $$2: number): Internal.VeryBiasedToBottomHeight;
        static readonly CODEC: Internal.Codec<Internal.VeryBiasedToBottomHeight>;
    }
    type VeryBiasedToBottomHeight_ = VeryBiasedToBottomHeight;
    interface IAnimatedEntity {
        abstract setAnimation(arg0: com.iafenvoy.uranus.animation.Animation_): void;
        abstract getAnimationTick(): number;
        abstract setAnimationTick(arg0: number): void;
        abstract getAnimation(): com.iafenvoy.uranus.animation.Animation;
        abstract getAnimations(): com.iafenvoy.uranus.animation.Animation[];
        set animation(arg0: com.iafenvoy.uranus.animation.Animation_)
        get animationTick(): number
        set animationTick(arg0: number)
        get animation(): com.iafenvoy.uranus.animation.Animation
        get animations(): com.iafenvoy.uranus.animation.Animation[]
        readonly NO_ANIMATION: com.iafenvoy.uranus.animation.Animation;
    }
    type IAnimatedEntity_ = IAnimatedEntity;
    abstract class AbstractPocketUpgrade implements Internal.IPocketUpgrade {
        abstract createPeripheral(arg0: Internal.IPocketAccess_): Internal.IPeripheral;
        getUpgradeID(): ResourceLocation;
        update(access: Internal.IPocketAccess_, peripheral: Internal.IPeripheral_): void;
        getCraftingItem(): Internal.ItemStack;
        onRightClick(world: Internal.Level_, access: Internal.IPocketAccess_, peripheral: Internal.IPeripheral_): boolean;
        getUpgradeData(stack: Internal.ItemStack_): Internal.CompoundTag;
        static getDefaultAdjective(id: ResourceLocation_): string;
        getUnlocalisedAdjective(): string;
        isItemSuitable(stack: Internal.ItemStack_): boolean;
        getUpgradeItem(upgradeData: Internal.CompoundTag_): Internal.ItemStack;
        get upgradeID(): ResourceLocation
        get craftingItem(): Internal.ItemStack
        get unlocalisedAdjective(): string
    }
    type AbstractPocketUpgrade_ = AbstractPocketUpgrade;
    class EventSource$Subscription {
        constructor(this$0: Internal.EventSource_<any>, subscriber: any)
        cancel(): void;
    }
    type EventSource$Subscription_ = EventSource$Subscription;
    abstract class AbstractDiodeBlock extends Internal.DiodeBlock implements com.simibubi.create.content.equipment.wrench.IWrenchable {
        constructor(builder: Internal.BlockBehaviour$Properties_)
        supportsExternalFaceHiding(state: Internal.BlockState_): boolean;
        isEnabled($$0: Internal.FeatureFlagSet_): boolean;
        hidesNeighborFace(level: Internal.BlockGetter_, pos: BlockPos_, state: Internal.BlockState_, neighborState: Internal.BlockState_, dir: Internal.Direction_): boolean;
        onTreeGrow(state: Internal.BlockState_, level: Internal.LevelReader_, placeFunction: Internal.BiConsumer_<BlockPos, Internal.BlockState>, randomSource: Internal.RandomSource_, pos: BlockPos_, config: Internal.TreeConfiguration_): boolean;
        getStateAtViewpoint(state: Internal.BlockState_, level: Internal.BlockGetter_, pos: BlockPos_, viewpoint: Vec3d_): Internal.BlockState;
        getBlockStates(): Internal.List<Internal.BlockState>;
        canSustainPlant(state: Internal.BlockState_, world: Internal.BlockGetter_, pos: BlockPos_, facing: Internal.Direction_, plantable: Internal.IPlantable_): boolean;
        addHitEffects(state: Internal.BlockState_, level: Internal.Level_, target: Internal.HitResult_, manager: Internal.ParticleEngine_): boolean;
        setRequiresTool(v: boolean): void;
        onSneakWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getToolModifiedState(state: Internal.BlockState_, context: Internal.UseOnContext_, toolAction: Internal.ToolAction_, simulate: boolean): Internal.BlockState;
        arch$registryName(): ResourceLocation;
        setLightEmission(v: number): void;
        getMod(): string;
        addLandingEffects(state1: Internal.BlockState_, level: Internal.ServerLevel_, pos: BlockPos_, state2: Internal.BlockState_, entity: Internal.LivingEntity_, numberOfParticles: number): boolean;
        updateAfterWrenched(newState: Internal.BlockState_, context: Internal.UseOnContext_): Internal.BlockState;
        onWrenched(state: Internal.BlockState_, context: Internal.UseOnContext_): Internal.InteractionResult;
        getRotatedBlockState(originalState: Internal.BlockState_, targetedFace: Internal.Direction_): Internal.BlockState;
        addRunningEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, entity: Internal.Entity_): boolean;
        getAppearance(state: Internal.BlockState_, renderView: Internal.BlockAndTintGetter_, pos: BlockPos_, side: Internal.Direction_, sourceState: Internal.BlockState_, sourcePos: BlockPos_): Internal.BlockState;
        setDestroySpeed(v: number): void;
        static playRemoveSound(level: Internal.Level_, pos: BlockPos_): void;
        /**
         * @deprecated
         * This method is marked to be removed in future!
        */
        getToolModifiedState(state: Internal.BlockState_, world: Internal.Level_, pos: BlockPos_, player: Internal.Player_, stack: Internal.ItemStack_, toolAction: Internal.ToolAction_): Internal.BlockState;
        addDestroyEffects(state: Internal.BlockState_, level: Internal.Level_, pos: BlockPos_, manager: Internal.ParticleEngine_): boolean;
        arch$holder(): Internal.Holder<Internal.Block>;
        emi(amount: number): Internal.EmiStack;
        static playRotateSound(level: Internal.Level_, pos: BlockPos_): void;
        emi(): Internal.EmiStack;
        get blockStates(): Internal.List<Internal.BlockState>
        set requiresTool(v: boolean)
        set lightEmission(v: number)
        get mod(): string
        set destroySpeed(v: number)
    }
    type AbstractDiodeBlock_ = AbstractDiodeBlock;
}
declare namespace me.jellysquid.mods.lithium.common.client {
    interface ClientWorldAccessor {
        abstract getEntityManager(): Internal.TransientEntitySectionManager<Internal.Entity>;
        get entityManager(): Internal.TransientEntitySectionManager<Internal.Entity>
        (): Internal.TransientEntitySectionManager_<Internal.Entity>;
    }
    type ClientWorldAccessor_ = ClientWorldAccessor;
}
declare namespace dev.engine_room.flywheel.api.material {
    interface Material {
        abstract polygonOffset(): boolean;
        abstract cutout(): Internal.CutoutShader;
        abstract useOverlay(): boolean;
        abstract light(): Internal.LightShader;
        abstract texture(): ResourceLocation;
        abstract cardinalLightingMode(): Internal.CardinalLightingMode;
        abstract backfaceCulling(): boolean;
        abstract transparency(): dev.engine_room.flywheel.api.material.Transparency;
        abstract useLight(): boolean;
        abstract blur(): boolean;
        abstract shaders(): Internal.MaterialShaders;
        abstract depthTest(): Internal.DepthTest;
        abstract writeMask(): Internal.WriteMask;
        abstract fog(): Internal.FogShader;
        abstract mipmap(): boolean;
    }
    type Material_ = Material;
}
